/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.spark.api.java.JavaSparkContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SparkTranslationContext {
    private final JavaSparkContext jsc;
    final JobInfo jobInfo;
    private final Map<String, Integer> consumptionCount = new HashMap<String, Integer>();
    private final Map<String, Coder> coderMap = new HashMap<String, Coder>();
    private final Map<String, Dataset> datasets = new LinkedHashMap<String, Dataset>();
    private final Set<Dataset> leaves = new LinkedHashSet<Dataset>();
    final SerializablePipelineOptions serializablePipelineOptions;
    private int sinkId = 0;

    public SparkTranslationContext(JavaSparkContext jsc, PipelineOptions options, JobInfo jobInfo) {
        this.jsc = jsc;
        this.serializablePipelineOptions = new SerializablePipelineOptions(options);
        this.jobInfo = jobInfo;
    }

    public JavaSparkContext getSparkContext() {
        return this.jsc;
    }

    public SerializablePipelineOptions getSerializableOptions() {
        return this.serializablePipelineOptions;
    }

    public void pushDataset(String pCollectionId, Dataset dataset) {
        dataset.setName(pCollectionId);
        SparkPipelineOptions sparkOptions = (SparkPipelineOptions)this.serializablePipelineOptions.get().as(SparkPipelineOptions.class);
        if (!sparkOptions.isCacheDisabled() && this.consumptionCount.getOrDefault(pCollectionId, 0) > 1) {
            String storageLevel = sparkOptions.getStorageLevel();
            @Nullable Coder coder = this.coderMap.get(pCollectionId);
            dataset.cache(storageLevel, coder);
        }
        this.datasets.put(pCollectionId, dataset);
        this.leaves.add(dataset);
    }

    public Dataset popDataset(String pCollectionId) {
        Dataset dataset = this.datasets.get(pCollectionId);
        this.leaves.remove(dataset);
        return dataset;
    }

    public void computeOutputs() {
        for (Dataset dataset : this.leaves) {
            dataset.action();
        }
    }

    void incrementConsumptionCountBy(String pCollectionId, int addend) {
        int count = this.consumptionCount.getOrDefault(pCollectionId, 0);
        this.consumptionCount.put(pCollectionId, count + addend);
    }

    void putCoder(String pCollectionId, Coder coder) {
        this.coderMap.put(pCollectionId, coder);
    }

    public int nextSinkId() {
        return this.sinkId++;
    }
}

