/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ResourceLevel;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceMetaData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static ResourceLevel defaultLevel_ = new ResourceLevel();
    private Object id_;
    private Object defaultValue_ = null;
    private ResourceLevel level_ = null;
    private boolean multipleAllowed_ = false;
    private Hashtable possibleValues_ = new Hashtable();
    private Hashtable possibleValuePresentations_ = new Hashtable();
    private Presentation presentation_;
    private boolean readOnly_;
    private Class type_;
    private boolean valueLimited_;
    static /* synthetic */ Class array$B;

    public ResourceMetaData(Object object, Class clazz, Presentation presentation) {
        this(object, clazz, true, null, null, false, false, presentation, null);
    }

    public ResourceMetaData(Object object, Class clazz, boolean bl, Object[] objectArray, Object object2, boolean bl2, boolean bl3, Presentation presentation, Presentation[] presentationArray) {
        if (object == null) {
            throw new NullPointerException("id");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.id_ = object;
        this.defaultValue_ = object2;
        this.level_ = defaultLevel_;
        this.type_ = clazz;
        this.readOnly_ = bl;
        this.valueLimited_ = bl2;
        this.multipleAllowed_ = bl3;
        this.presentation_ = presentation;
        if (objectArray != null) {
            this.setPossibleValues(objectArray, null);
        }
        if (object2 != null) {
            this.validateValue(object2);
        }
        if (presentationArray != null) {
            if (objectArray == null) {
                throw new NullPointerException("possibleValues");
            }
            if (presentationArray.length > objectArray.length) {
                throw new ExtendedIllegalArgumentException("possibleValuePresentations", 2);
            }
            for (int i = 0; i < presentationArray.length; ++i) {
                this.possibleValuePresentations_.put(objectArray[i], presentationArray[i]);
            }
        }
    }

    private static boolean arrayCompare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean areMultipleAllowed() {
        return this.multipleAllowed_;
    }

    public Object getID() {
        return this.id_;
    }

    public Object getDefaultValue() {
        return this.defaultValue_;
    }

    public ResourceLevel getLevel() {
        return this.level_;
    }

    public Presentation getPresentation() {
        return this.presentation_;
    }

    public Object[] getPossibleValues() {
        Object[] objectArray = new Object[this.possibleValues_.size()];
        Enumeration enumeration = this.possibleValues_.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = enumeration.nextElement();
        }
        return objectArray;
    }

    Object[] getPossibleValues(String string) {
        Object object;
        if (string == null) {
            throw new NullPointerException("level");
        }
        Vector vector = new Vector(this.possibleValues_.size());
        Enumeration enumeration = this.possibleValues_.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ResourceLevel resourceLevel = (ResourceLevel)this.possibleValues_.get(object);
            if (!resourceLevel.checkLevel(string)) continue;
            vector.addElement(object);
        }
        object = new Object[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Presentation getPossibleValuePresentation(Object object) {
        if (object == null) {
            throw new NullPointerException("possibleValue");
        }
        this.validateValue(object);
        if (this.possibleValuePresentations_.containsKey(object)) {
            return (Presentation)this.possibleValuePresentations_.get(object);
        }
        return null;
    }

    public Presentation[] getPossibleValuePresentations() {
        Object[] objectArray = this.getPossibleValues();
        Presentation[] presentationArray = new Presentation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            presentationArray[i] = this.getPossibleValuePresentation(objectArray[i]);
        }
        return presentationArray;
    }

    Presentation[] getPossibleValuePresentations(String string) {
        if (string == null) {
            throw new NullPointerException("level");
        }
        Object[] objectArray = this.getPossibleValues(string);
        Presentation[] presentationArray = new Presentation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            presentationArray[i] = this.getPossibleValuePresentation(objectArray[i]);
        }
        return presentationArray;
    }

    public Class getType() {
        return this.type_;
    }

    public boolean isReadOnly() {
        return this.readOnly_;
    }

    public boolean isValueLimited() {
        return this.valueLimited_;
    }

    public void setLevel(ResourceLevel resourceLevel) {
        this.level_ = resourceLevel == null ? defaultLevel_ : resourceLevel;
    }

    public void setPossibleValues(Object[] objectArray, ResourceLevel resourceLevel) {
        int n;
        if (objectArray == null) {
            throw new NullPointerException("possibleValues");
        }
        Class<?> clazz = this.multipleAllowed_ && this.type_.isArray() ? this.type_.getComponentType() : this.type_;
        for (n = 0; n < objectArray.length; ++n) {
            if (clazz.isAssignableFrom(objectArray[n].getClass())) continue;
            throw new ExtendedIllegalArgumentException("possibleValues[" + n + "]", 2);
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (resourceLevel == null) {
                this.possibleValues_.put(objectArray[n], defaultLevel_);
                continue;
            }
            this.possibleValues_.put(objectArray[n], resourceLevel);
        }
    }

    public String toString() {
        return this.id_.toString();
    }

    private int validateValue(Object object, Object[] objectArray) {
        int n = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            if (object.getClass().equals(array$B == null ? ResourceMetaData.class$("[B") : array$B)) {
                if (!ResourceMetaData.arrayCompare((byte[])object, (byte[])objectArray[i])) continue;
                n = i;
                break;
            }
            if (!object.equals(objectArray[i])) continue;
            n = i;
            break;
        }
        if (this.valueLimited_ && n < 0) {
            throw new ExtendedIllegalArgumentException("value(" + object + ") for id(" + this.id_ + ")", 2);
        }
        return n;
    }

    Object validateValue(Object object) {
        if (object == null) {
            throw new NullPointerException("value");
        }
        Class<?> clazz = object.getClass();
        if (this.multipleAllowed_) {
            if (clazz.isArray()) {
                if (!this.type_.isAssignableFrom(clazz.getComponentType())) {
                    throw new ExtendedIllegalArgumentException("value(" + object + ") type(" + clazz + ") for id(" + this.id_ + ")", 2);
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.validateValue(objectArray[i], this.getPossibleValues()) >= 0) continue;
                    return object;
                }
                return object;
            }
            if (!this.type_.isAssignableFrom(clazz)) {
                throw new ExtendedIllegalArgumentException("value(" + object + ") type(" + clazz + ") for id(" + this.id_ + ")", 2);
            }
            this.validateValue(object, this.getPossibleValues());
            Object[] objectArray = (Object[])Array.newInstance(this.type_, 1);
            objectArray[0] = object;
            return objectArray;
        }
        if (!this.type_.isAssignableFrom(clazz)) {
            throw new ExtendedIllegalArgumentException("value(" + object + ") type(" + clazz + ") for id(" + this.id_ + ")", 2);
        }
        this.validateValue(object, this.getPossibleValues());
        return object;
    }

    int validateValue(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("value");
        }
        if (string == null) {
            throw new NullPointerException("level");
        }
        if (!this.type_.isAssignableFrom(object.getClass())) {
            throw new ExtendedIllegalArgumentException("value(" + object + ") type(" + object.getClass() + ") for id(" + this.id_ + ")", 2);
        }
        return this.validateValue(object, this.getPossibleValues(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

