/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionAdapter;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VPropertiesAction;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;

class PopupMenuAdapter
extends MouseAdapter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VActionContext actionContext_;
    private VPane pane_;
    private VPropertiesAction propertiesAction_;

    public PopupMenuAdapter(VPane vPane, VActionContext vActionContext) {
        this.pane_ = vPane;
        this.actionContext_ = vActionContext;
        this.propertiesAction_ = new VPropertiesAction();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getPoint());
        }
    }

    private void showPopupMenu(Component component, Point point) {
        JMenuItem jMenuItem;
        VAction[] vActionArray;
        VObject vObject = this.pane_.getObjectAt(point);
        VNode vNode = this.pane_.getRoot();
        int n = 0;
        VObject vObject2 = null;
        if (vObject != null) {
            vObject2 = vObject;
        } else if (vNode != null) {
            vObject2 = vNode;
            if (component instanceof JTree) {
                ((JTree)component).getSelectionModel().clearSelection();
            } else if (component instanceof JTable) {
                ((JTable)component).getSelectionModel().clearSelection();
            }
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (vObject2 != null && (vActionArray = vObject2.getActions()) != null) {
            for (int i = 0; i < vActionArray.length; ++i) {
                jMenuItem = new JMenuItem(vActionArray[i].getText());
                jMenuItem.addActionListener(new VActionAdapter(vActionArray[i], this.actionContext_));
                jMenuItem.setEnabled(vActionArray[i].isEnabled());
                jPopupMenu.add(jMenuItem);
                ++n;
            }
            if (vActionArray.length > 0) {
                jPopupMenu.addSeparator();
            }
        }
        if (vObject2 != null) {
            jMenuItem = new JMenuItem(this.propertiesAction_.getText());
            if (vObject2.getPropertiesPane() != null) {
                this.propertiesAction_.setObject(vObject2);
                jMenuItem.addActionListener(new VActionAdapter(this.propertiesAction_, this.actionContext_));
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem);
            ++n;
        }
        if (n > 0) {
            jPopupMenu.show(component, point.x, point.y);
        }
    }
}

