/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;

class WriteGroupedRecordsToFiles<DestinationT, ElementT>
extends DoFn<KV<DestinationT, Iterable<ElementT>>, WriteBundlesToFiles.Result<DestinationT>> {
    private final PCollectionView<String> tempFilePrefix;
    private final long maxFileSize;
    private final RowWriterFactory<ElementT, DestinationT> rowWriterFactory;

    WriteGroupedRecordsToFiles(PCollectionView<String> tempFilePrefix, long maxFileSize, RowWriterFactory<ElementT, DestinationT> rowWriterFactory) {
        this.tempFilePrefix = tempFilePrefix;
        this.maxFileSize = maxFileSize;
        this.rowWriterFactory = rowWriterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c, @DoFn.Element KV<DestinationT, Iterable<ElementT>> element, DoFn.OutputReceiver<WriteBundlesToFiles.Result<DestinationT>> o) throws Exception {
        String tempFilePrefix = (String)c.sideInput(this.tempFilePrefix);
        try (BigQueryRowWriter<ElementT> writer = this.rowWriterFactory.createRowWriter(tempFilePrefix, element.getKey());){
            for (Object tableRow : (Iterable)element.getValue()) {
                if (writer.getByteSize() > this.maxFileSize) {
                    writer.close();
                    writer = this.rowWriterFactory.createRowWriter(tempFilePrefix, element.getKey());
                    BigQueryRowWriter.Result result = writer.getResult();
                    o.output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((KV)c.element()).getKey()));
                }
                writer.write(tableRow);
            }
        }
        BigQueryRowWriter.Result result = writer.getResult();
        o.output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((KV)c.element()).getKey()));
    }
}

