/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRowFn;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

public class BigtableRowToBeamRow
extends PTransform<PCollection<Row>, PCollection<org.apache.beam.sdk.values.Row>>
implements Serializable {
    private final Schema schema;

    public BigtableRowToBeamRow(Schema schema) {
        this.schema = schema;
    }

    public PCollection<org.apache.beam.sdk.values.Row> expand(PCollection<Row> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new ToBeamRowFn(this.schema)));
    }

    private static class ToBeamRowFn
    extends BigtableRowToBeamRowFn {
        ToBeamRowFn(Schema schema) {
            super(schema);
        }

        public org.apache.beam.sdk.values.Row apply(Row bigtableRow) {
            return this.bigtableRowToBeamRow(bigtableRow);
        }

        private org.apache.beam.sdk.values.Row cellToRow(Cell cell, Schema cellSchema) {
            Row.FieldValueBuilder rowBuilder = org.apache.beam.sdk.values.Row.withSchema((Schema)cellSchema).withFieldValue("val", this.getCellValue(cell, cellSchema.getField("val").getType()));
            if (cellSchema.hasField("timestampMicros")) {
                rowBuilder.withFieldValue("timestampMicros", (Object)cell.getTimestampMicros());
            }
            if (cellSchema.hasField("labels")) {
                rowBuilder.withFieldValue("labels", (Object)cell.getLabelsList());
            }
            return rowBuilder.build();
        }

        private Object columnToRow(Column column, Schema schema) {
            String columnName = column.getQualifier().toStringUtf8();
            Schema.FieldType columnType = schema.getField(columnName).getType();
            List cells = column.getCellsList();
            switch (columnType.getTypeName()) {
                case ARRAY: {
                    Schema.FieldType collectionElementType = columnType.getCollectionElementType();
                    if (collectionElementType != null) {
                        return cells.stream().map(cell -> this.getCellValue((Cell)cell, collectionElementType)).collect(Collectors.toList());
                    }
                    throw new NullPointerException("Null collectionElementType at column " + columnName);
                }
                case ROW: {
                    Schema rowSchema = columnType.getRowSchema();
                    if (rowSchema == null) {
                        throw new NullPointerException("Null row schema at column " + columnName);
                    }
                    return this.cellToRow(this.getLastCell(cells), rowSchema);
                }
            }
            return this.getCellValue(this.getLastCell(cells), columnType);
        }

        private org.apache.beam.sdk.values.Row familyToRow(Family family, Schema schema) {
            Map<String, Object> columns = family.getColumnsList().stream().filter(column -> schema.hasField(column.getQualifier().toStringUtf8())).map(column -> {
                String columnName = column.getQualifier().toStringUtf8();
                return KV.of((Object)columnName, (Object)this.columnToRow((Column)column, schema));
            }).collect(Collectors.toMap(KV::getKey, kv -> {
                Object value = kv.getValue();
                if (value == null) {
                    throw new NullPointerException("Null value at column " + (String)kv.getKey());
                }
                return value;
            }));
            return org.apache.beam.sdk.values.Row.withSchema((Schema)schema).withFieldValues(columns).build();
        }

        private org.apache.beam.sdk.values.Row bigtableRowToBeamRow(Row bigtableRow) {
            Row.FieldValueBuilder rowBuilder = org.apache.beam.sdk.values.Row.withSchema((Schema)this.schema).withFieldValue("key", (Object)bigtableRow.getKey().toStringUtf8());
            bigtableRow.getFamiliesList().stream().filter(family -> this.schema.hasField(family.getName())).forEach(family -> {
                Schema familySchema = this.schema.getField(family.getName()).getType().getRowSchema();
                if (familySchema == null) {
                    throw new NullPointerException("Null family schema at family " + family.getName());
                }
                rowBuilder.withFieldValue(family.getName(), (Object)this.familyToRow((Family)family, familySchema));
            });
            return rowBuilder.build();
        }
    }
}

