/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.service.AutoService;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.TimestampBound;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Experimental(value=Experimental.Kind.PORTABILITY)
@AutoService(value={ExternalTransformRegistrar.class})
public class SpannerTransformRegistrar
implements ExternalTransformRegistrar {
    public static final String INSERT_URN = "beam:transform:org.apache.beam:spanner_insert:v1";
    public static final String UPDATE_URN = "beam:transform:org.apache.beam:spanner_update:v1";
    public static final String REPLACE_URN = "beam:transform:org.apache.beam:spanner_replace:v1";
    public static final String INSERT_OR_UPDATE_URN = "beam:transform:org.apache.beam:spanner_insert_or_update:v1";
    public static final String DELETE_URN = "beam:transform:org.apache.beam:spanner_delete:v1";
    public static final String READ_URN = "beam:transform:org.apache.beam:spanner_read:v1";

    public @NonNull Map<String, ExternalTransformBuilder<?, ?, ?>> knownBuilderInstances() {
        return ImmutableMap.builder().put((Object)INSERT_URN, (Object)new InsertBuilder()).put((Object)UPDATE_URN, (Object)new UpdateBuilder()).put((Object)REPLACE_URN, (Object)new ReplaceBuilder()).put((Object)INSERT_OR_UPDATE_URN, (Object)new InsertOrUpdateBuilder()).put((Object)DELETE_URN, (Object)new DeleteBuilder()).put((Object)READ_URN, (Object)new ReadBuilder()).build();
    }

    @Experimental(value=Experimental.Kind.PORTABILITY)
    private static abstract class WriteBuilder
    implements ExternalTransformBuilder<Configuration, PCollection<Row>, PDone> {
        private final Mutation.Op operation;

        WriteBuilder(Mutation.Op operation) {
            this.operation = operation;
        }

        public @NonNull PTransform<PCollection<Row>, PDone> buildExternal(Configuration configuration) {
            configuration.checkMandatoryFields();
            SpannerIO.Write writeTransform = SpannerIO.write().withProjectId(configuration.projectId).withDatabaseId(configuration.databaseId).withInstanceId(configuration.instanceId);
            if (configuration.maxBatchSizeBytes != null) {
                writeTransform = writeTransform.withBatchSizeBytes(configuration.maxBatchSizeBytes);
            }
            if (configuration.maxNumberMutations != null) {
                writeTransform = writeTransform.withMaxNumMutations(configuration.maxNumberMutations);
            }
            if (configuration.maxNumberRows != null) {
                writeTransform = writeTransform.withMaxNumRows(configuration.maxNumberRows);
            }
            if (configuration.groupingFactor != null) {
                writeTransform = writeTransform.withGroupingFactor(configuration.groupingFactor);
            }
            if (configuration.host != null) {
                writeTransform = writeTransform.withHost(configuration.host);
            }
            if (configuration.emulatorHost != null) {
                writeTransform = writeTransform.withEmulatorHost(configuration.emulatorHost);
            }
            if (configuration.commitDeadline != null) {
                writeTransform = writeTransform.withCommitDeadline(configuration.commitDeadline);
            }
            if (configuration.maxCumulativeBackoff != null) {
                writeTransform = writeTransform.withMaxCumulativeBackoff(configuration.maxCumulativeBackoff);
            }
            return SpannerIO.WriteRows.of(writeTransform, this.operation, configuration.table);
        }

        public static class Configuration
        extends CrossLanguageConfiguration {
            private String table = "";
            private @Nullable Long maxBatchSizeBytes;
            private @Nullable Long maxNumberMutations;
            private @Nullable Long maxNumberRows;
            private @Nullable Integer groupingFactor;
            private @Nullable Duration commitDeadline;
            private @Nullable Duration maxCumulativeBackoff;

            public void setTable(String table) {
                this.table = table;
            }

            public void setMaxBatchSizeBytes(@Nullable Long maxBatchSizeBytes) {
                this.maxBatchSizeBytes = maxBatchSizeBytes;
            }

            public void setMaxNumberMutations(@Nullable Long maxNumberMutations) {
                this.maxNumberMutations = maxNumberMutations;
            }

            public void setMaxNumberRows(@Nullable Long maxNumberRows) {
                this.maxNumberRows = maxNumberRows;
            }

            public void setGroupingFactor(@Nullable Long groupingFactor) {
                if (groupingFactor != null) {
                    this.groupingFactor = groupingFactor.intValue();
                }
            }

            public void setCommitDeadline(@Nullable Long commitDeadline) {
                if (commitDeadline != null) {
                    this.commitDeadline = Duration.standardSeconds((long)commitDeadline);
                }
            }

            public void setMaxCumulativeBackoff(@Nullable Long maxCumulativeBackoff) {
                if (maxCumulativeBackoff != null) {
                    this.maxCumulativeBackoff = Duration.standardSeconds((long)maxCumulativeBackoff);
                }
            }
        }
    }

    @Experimental(value=Experimental.Kind.PORTABILITY)
    public static class DeleteBuilder
    extends WriteBuilder {
        public DeleteBuilder() {
            super(Mutation.Op.DELETE);
        }
    }

    @Experimental(value=Experimental.Kind.PORTABILITY)
    public static class ReplaceBuilder
    extends WriteBuilder {
        public ReplaceBuilder() {
            super(Mutation.Op.REPLACE);
        }
    }

    @Experimental(value=Experimental.Kind.PORTABILITY)
    public static class InsertOrUpdateBuilder
    extends WriteBuilder {
        public InsertOrUpdateBuilder() {
            super(Mutation.Op.INSERT_OR_UPDATE);
        }
    }

    @Experimental(value=Experimental.Kind.PORTABILITY)
    public static class UpdateBuilder
    extends WriteBuilder {
        public UpdateBuilder() {
            super(Mutation.Op.UPDATE);
        }
    }

    @Experimental(value=Experimental.Kind.PORTABILITY)
    public static class InsertBuilder
    extends WriteBuilder {
        public InsertBuilder() {
            super(Mutation.Op.INSERT);
        }
    }

    @Experimental(value=Experimental.Kind.PORTABILITY)
    public static class ReadBuilder
    implements ExternalTransformBuilder<Configuration, PBegin, PCollection<Row>> {
        public @NonNull PTransform<PBegin, PCollection<Row>> buildExternal(Configuration configuration) {
            TimestampBound timestampBound;
            configuration.checkMandatoryFields();
            SpannerIO.Read readTransform = SpannerIO.read().withProjectId(configuration.projectId).withDatabaseId(configuration.databaseId).withInstanceId(configuration.instanceId).withReadOperation(configuration.getReadOperation());
            if (configuration.host != null) {
                readTransform = readTransform.withHost(configuration.host);
            }
            if (configuration.emulatorHost != null) {
                readTransform = readTransform.withEmulatorHost(configuration.emulatorHost);
            }
            if ((timestampBound = configuration.getTimestampBound()) != null) {
                readTransform = readTransform.withTimestampBound(timestampBound);
            }
            if (configuration.batching != null) {
                readTransform = readTransform.withBatching(configuration.batching);
            }
            return new SpannerIO.ReadRows(readTransform, configuration.schema);
        }

        public static class Configuration
        extends CrossLanguageConfiguration {
            private Schema schema = Schema.builder().build();
            private @Nullable String sql;
            private @Nullable String table;
            private @Nullable Boolean batching;
            private @Nullable String timestampBoundMode;
            private @Nullable String readTimestamp;
            private @Nullable String timeUnit;
            private @Nullable Long staleness;

            public void setSql(@Nullable String sql) {
                this.sql = sql;
            }

            public void setTable(@Nullable String table) {
                this.table = table;
            }

            public void setBatching(@Nullable Boolean batching) {
                this.batching = batching;
            }

            public void setTimestampBoundMode(@Nullable String timestampBoundMode) {
                this.timestampBoundMode = timestampBoundMode;
            }

            public void setSchema(byte[] schema) throws InvalidProtocolBufferException {
                this.schema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)SchemaApi.Schema.parseFrom((byte[])schema));
            }

            public void setReadTimestamp(@Nullable String readTimestamp) {
                this.readTimestamp = readTimestamp;
            }

            public void setTimeUnit(@Nullable String timeUnit) {
                this.timeUnit = timeUnit;
            }

            public void setStaleness(@Nullable Long staleness) {
                this.staleness = staleness;
            }

            private @Nullable TimestampBound getTimestampBound() {
                if (this.timestampBoundMode == null) {
                    return null;
                }
                TimestampBound.Mode mode = TimestampBound.Mode.valueOf((String)this.timestampBoundMode);
                switch (mode) {
                    case STRONG: {
                        return TimestampBound.strong();
                    }
                    case MAX_STALENESS: 
                    case EXACT_STALENESS: {
                        if (this.staleness == null) {
                            throw new NullPointerException("Staleness value cannot be empty when MAX_STALENESS or EXACT_STALENESS mode is selected");
                        }
                        if (this.timeUnit == null) {
                            throw new NullPointerException("Time unit cannot be null when MAX_STALENESS or EXACT_STALENESS mode is selected");
                        }
                        return mode == TimestampBound.Mode.MAX_STALENESS ? TimestampBound.ofMaxStaleness((long)this.staleness, (TimeUnit)TimeUnit.valueOf(this.timeUnit)) : TimestampBound.ofExactStaleness((long)this.staleness, (TimeUnit)TimeUnit.valueOf(this.timeUnit));
                    }
                    case READ_TIMESTAMP: 
                    case MIN_READ_TIMESTAMP: {
                        if (this.readTimestamp == null) {
                            throw new NullPointerException("Timestamp cannot be null when READ_TIMESTAMP or MIN_READ_TIMESTAMP mode is selected");
                        }
                        return mode == TimestampBound.Mode.READ_TIMESTAMP ? TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)this.readTimestamp)) : TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)this.readTimestamp));
                    }
                }
                throw new IllegalArgumentException("Unknown timestamp bound mode: " + mode);
            }

            public ReadOperation getReadOperation() {
                if (this.sql != null && this.table != null) {
                    throw new IllegalStateException("Query and table params are mutually exclusive. Set just one of them.");
                }
                ReadOperation readOperation = ReadOperation.create();
                if (this.sql != null) {
                    return readOperation.withQuery(this.sql);
                }
                if (Schema.builder().build().equals((Object)this.schema)) {
                    throw new IllegalArgumentException("Schema can't be empty");
                }
                if (this.table != null) {
                    return readOperation.withTable(this.table).withColumns(this.schema.getFieldNames());
                }
                throw new IllegalStateException("Can't happen");
            }
        }
    }

    public static abstract class CrossLanguageConfiguration {
        String instanceId = "";
        String databaseId = "";
        String projectId = "";
        @Nullable String host;
        @Nullable String emulatorHost;

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setHost(@Nullable String host) {
            this.host = host;
        }

        public void setEmulatorHost(@Nullable String emulatorHost) {
            this.emulatorHost = emulatorHost;
        }

        void checkMandatoryFields() {
            if (this.projectId.isEmpty()) {
                throw new IllegalArgumentException("projectId can't be empty");
            }
            if (this.databaseId.isEmpty()) {
                throw new IllegalArgumentException("databaseId can't be empty");
            }
            if (this.instanceId.isEmpty()) {
                throw new IllegalArgumentException("instanceId can't be empty");
            }
        }
    }
}

