/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.okhttp.internal.tls;

import com.clickhouse.client.internal.okhttp.internal.tls.TrustRootIndex;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificateChainCleaner {
    private final TrustRootIndex trustRootIndex;

    public CertificateChainCleaner(TrustRootIndex trustRootIndex) {
        this.trustRootIndex = trustRootIndex;
    }

    public List<Certificate> clean(List<Certificate> chain) throws SSLPeerUnverifiedException {
        X509Certificate toVerify;
        ArrayDeque<Certificate> queue = new ArrayDeque<Certificate>(chain);
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        result.add((Certificate)queue.removeFirst());
        block0: while (true) {
            X509Certificate caCert;
            if ((caCert = this.trustRootIndex.findByIssuerAndSignature(toVerify = (X509Certificate)result.get(result.size() - 1))) != null) {
                if (result.size() > 1 || !toVerify.equals(caCert)) {
                    result.add(caCert);
                }
                return result;
            }
            Iterator i = queue.iterator();
            while (i.hasNext()) {
                X509Certificate signingCert = (X509Certificate)i.next();
                if (!toVerify.getIssuerDN().equals(signingCert.getSubjectDN()) || !this.verifySignature(toVerify, signingCert)) continue;
                i.remove();
                result.add(signingCert);
                continue block0;
            }
            break;
        }
        throw new SSLPeerUnverifiedException("Failed to find a cert that signed " + toVerify);
    }

    private boolean verifySignature(X509Certificate toVerify, X509Certificate signingCert) {
        try {
            toVerify.verify(signingCert.getPublicKey());
            return true;
        }
        catch (GeneralSecurityException verifyFailed) {
            return false;
        }
    }
}

