/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class DockerContainerEnvironment
implements RemoteEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainerEnvironment.class);
    private final Object lock = new Object();
    private final DockerCommand docker;
    private final RunnerApi.Environment environment;
    private final String containerId;
    private final InstructionRequestHandler instructionHandler;
    private final boolean retainDockerContainer;
    private boolean isClosed = false;

    static DockerContainerEnvironment create(DockerCommand docker, RunnerApi.Environment environment, String containerId, InstructionRequestHandler instructionHandler, boolean retainDockerContainer) {
        return new DockerContainerEnvironment(docker, environment, containerId, instructionHandler, retainDockerContainer);
    }

    private DockerContainerEnvironment(DockerCommand docker, RunnerApi.Environment environment, String containerId, InstructionRequestHandler instructionHandler, boolean retainDockerContainer) {
        this.docker = docker;
        this.environment = environment;
        this.containerId = containerId;
        this.instructionHandler = instructionHandler;
        this.retainDockerContainer = retainDockerContainer;
    }

    @Override
    public RunnerApi.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public InstructionRequestHandler getInstructionRequestHandler() {
        return this.instructionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                this.isClosed = true;
                this.instructionHandler.close();
                String containerLogs = this.docker.getContainerLogs(this.containerId);
                LOG.info("Closing Docker container {}. Logs:\n{}", (Object)this.containerId, (Object)containerLogs);
                this.docker.killContainer(this.containerId);
                if (!this.retainDockerContainer) {
                    this.docker.removeContainer(this.containerId);
                }
            }
        }
    }
}

