/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.status;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.IdGenerators;
import org.apache.beam.sdk.fn.stream.SynchronizedStreamObserver;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerStatusClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerStatusClient.class);
    private final IdGenerator idGenerator = IdGenerators.incrementingLongs();
    private final StreamObserver<BeamFnApi.WorkerStatusRequest> requestReceiver;
    private final Map<String, CompletableFuture<BeamFnApi.WorkerStatusResponse>> pendingResponses = Collections.synchronizedMap(new HashMap());
    private final String workerId;
    private AtomicBoolean isClosed = new AtomicBoolean(false);

    private WorkerStatusClient(String workerId, StreamObserver<BeamFnApi.WorkerStatusRequest> requestReceiver) {
        this.requestReceiver = SynchronizedStreamObserver.wrapping(requestReceiver);
        this.workerId = workerId;
    }

    public static WorkerStatusClient forRequestObserver(String workerId, StreamObserver<BeamFnApi.WorkerStatusRequest> requestObserver) {
        return new WorkerStatusClient(workerId, requestObserver);
    }

    public CompletableFuture<BeamFnApi.WorkerStatusResponse> getWorkerStatus() {
        BeamFnApi.WorkerStatusRequest request = BeamFnApi.WorkerStatusRequest.newBuilder().setId(this.idGenerator.getId()).build();
        return this.getWorkerStatus(request);
    }

    CompletableFuture<BeamFnApi.WorkerStatusResponse> getWorkerStatus(BeamFnApi.WorkerStatusRequest request) {
        CompletableFuture<BeamFnApi.WorkerStatusResponse> future = new CompletableFuture<BeamFnApi.WorkerStatusResponse>();
        if (this.isClosed.get()) {
            future.completeExceptionally(new RuntimeException("Worker status client already closed."));
            return future;
        }
        this.pendingResponses.put(request.getId(), future);
        this.requestReceiver.onNext((Object)request);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        Map<String, CompletableFuture<BeamFnApi.WorkerStatusResponse>> map = this.pendingResponses;
        synchronized (map) {
            for (CompletableFuture<BeamFnApi.WorkerStatusResponse> pendingResponse : this.pendingResponses.values()) {
                pendingResponse.completeExceptionally(new RuntimeException("Fn Status Api client shut down while waiting for the request"));
            }
            this.pendingResponses.clear();
        }
        this.requestReceiver.onCompleted();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public StreamObserver<BeamFnApi.WorkerStatusResponse> getResponseObserver() {
        return new ResponseStreamObserver();
    }

    private class ResponseStreamObserver
    implements StreamObserver<BeamFnApi.WorkerStatusResponse> {
        private ResponseStreamObserver() {
        }

        public void onNext(BeamFnApi.WorkerStatusResponse response) {
            if (WorkerStatusClient.this.isClosed.get()) {
                return;
            }
            CompletableFuture future = (CompletableFuture)WorkerStatusClient.this.pendingResponses.remove(response.getId());
            if (future != null) {
                future.complete(response);
            } else {
                LOG.warn(String.format("Received response for status with unknown response id %s and status %s", response.getId(), response.getStatusInfo()));
            }
        }

        public void onError(Throwable throwable) {
            LOG.error("{} received error.", (Object)WorkerStatusClient.class.getSimpleName(), (Object)throwable);
            this.onCompleted();
        }

        public void onCompleted() {
            try {
                WorkerStatusClient.this.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing Fn status api client", (Throwable)e);
            }
        }
    }
}

