/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.diagnostic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.diagnostic.ConnectivityResult;
import org.apache.ignite.internal.management.diagnostic.ConnectivityTask;
import org.apache.ignite.internal.management.diagnostic.DiagnosticConnectivityCommandArg;
import org.apache.ignite.internal.util.IgniteUtils;

public class DiagnosticConnectivityCommand
implements ComputeCommand<DiagnosticConnectivityCommandArg, Map<ClusterNode, ConnectivityResult>> {
    private static final List<String> TABLE_HEADER = Arrays.asList("SOURCE-NODE-ID", "SOURCE-CONSISTENT-ID", "SOURCE-NODE-TYPE", "DESTINATION-NODE-ID", "DESTINATION_CONSISTENT_ID", "DESTINATION-NODE-TYPE");
    private static final String NODE_TYPE_CLIENT = "CLIENT";
    private static final String NODE_TYPE_SERVER = "SERVER";

    @Override
    public String description() {
        return "View connectvity state of all nodes in cluster";
    }

    @Override
    public Class<DiagnosticConnectivityCommandArg> argClass() {
        return DiagnosticConnectivityCommandArg.class;
    }

    @Override
    public Class<ConnectivityTask> taskClass() {
        return ConnectivityTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, DiagnosticConnectivityCommandArg arg) {
        arg.nodes(nodes.stream().map(GridClientNode::nodeId).collect(Collectors.toList()).toArray(IgniteUtils.EMPTY_UUIDS));
        return null;
    }

    @Override
    public void printResult(DiagnosticConnectivityCommandArg arg, Map<ClusterNode, ConnectivityResult> res, Consumer<String> printer) {
        boolean[] hasFailed = new boolean[]{false};
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(TABLE_HEADER);
        for (Map.Entry<ClusterNode, ConnectivityResult> entry : res.entrySet()) {
            ClusterNode key = entry.getKey();
            String id = key.id().toString();
            String consId = key.consistentId().toString();
            String isClient = key.isClient() ? NODE_TYPE_CLIENT : NODE_TYPE_SERVER;
            ConnectivityResult val = entry.getValue();
            Map<ClusterNode, Boolean> statuses = val.getNodeIds();
            List row = statuses.entrySet().stream().map(nodeStat -> {
                ClusterNode remoteNode = (ClusterNode)nodeStat.getKey();
                String remoteId = remoteNode.id().toString();
                String remoteConsId = remoteNode.consistentId().toString();
                String nodeType = remoteNode.isClient() ? NODE_TYPE_CLIENT : NODE_TYPE_SERVER;
                Boolean status = (Boolean)nodeStat.getValue();
                if (!status.booleanValue()) {
                    hasFailed[0] = true;
                    return Arrays.asList(id, consId, isClient, remoteId, remoteConsId, nodeType);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            table.addAll(row);
        }
        if (hasFailed[0]) {
            printer.accept("There is no connectivity between the following nodes:\n" + DiagnosticConnectivityCommand.formatAsTable(table));
        } else {
            printer.accept("There are no connectivity problems.");
        }
    }

    public static String formatAsTable(List<List<String>> rows) {
        int[] maxLengths = new int[rows.get(0).size()];
        for (List<String> list : rows) {
            for (int i = 0; i < list.size(); ++i) {
                maxLengths[i] = Math.max(maxLengths[i], list.get(i).length());
            }
        }
        StringBuilder formatBuilder = new StringBuilder();
        for (int maxLength : maxLengths) {
            formatBuilder.append("%-").append(maxLength + 2).append("s");
        }
        String string = formatBuilder.toString();
        StringBuilder result = new StringBuilder();
        for (List<String> row : rows) {
            result.append(String.format(string, row.toArray())).append("\n");
        }
        return result.toString();
    }
}

