/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.property;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.management.SystemViewCommand;
import org.apache.ignite.internal.management.SystemViewTask;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.property.PropertiesListResult;
import org.apache.ignite.internal.management.property.PropertiesListTask;
import org.apache.ignite.internal.management.property.PropertyListCommandArg;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;

public class PropertyListCommand
implements ComputeCommand<PropertyListCommandArg, PropertiesListResult> {
    @Override
    public String description() {
        return "Print list of available properties";
    }

    @Override
    public Class<PropertyListCommandArg> argClass() {
        return PropertyListCommandArg.class;
    }

    @Override
    public Class<PropertiesListTask> taskClass() {
        return PropertiesListTask.class;
    }

    @Override
    public void printResult(PropertyListCommandArg arg, PropertiesListResult res, Consumer<String> printer) {
        if (arg.info()) {
            List<SystemViewTask.SimpleType> types = F.asList(new String[]{"Name", "Value", "Description"}).stream().map(x -> SystemViewTask.SimpleType.STRING).collect(Collectors.toList());
            List<List<?>> data = res.properties().stream().map(p -> F.asList(new String[]{(String)p.get1(), (String)p.get2(), (String)p.get3()})).collect(Collectors.toList());
            SystemViewCommand.printTable(F.asList(new String[]{"Name", "Value", "Description"}), types, data, printer);
        } else {
            res.properties().stream().map(GridTuple3::get1).forEach(printer);
        }
    }
}

