/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.util.IgniteNameUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.TopologyService;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;

public class IgniteComputeImpl
implements IgniteCompute {
    private static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private final TopologyService topologyService;
    private final IgniteTablesInternal tables;
    private final ComputeComponent computeComponent;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    public IgniteComputeImpl(TopologyService topologyService, IgniteTablesInternal tables, ComputeComponent computeComponent) {
        this.topologyService = topologyService;
        this.tables = tables;
        this.computeComponent = computeComponent;
    }

    public <R> CompletableFuture<R> execute(Set<ClusterNode> nodes, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        Objects.requireNonNull(nodes);
        Objects.requireNonNull(jobClass);
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be empty.");
        }
        return this.executeOnOneNode(this.randomNode(nodes), jobClass, args);
    }

    public <R> CompletableFuture<R> execute(Set<ClusterNode> nodes, String jobClassName, Object ... args) {
        Objects.requireNonNull(nodes);
        Objects.requireNonNull(jobClassName);
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be empty.");
        }
        return this.executeOnOneNode(this.randomNode(nodes), jobClassName, args);
    }

    private ClusterNode randomNode(Set<ClusterNode> nodes) {
        int nodesToSkip = this.random.nextInt(nodes.size());
        Iterator<ClusterNode> iterator = nodes.iterator();
        for (int i = 0; i < nodesToSkip; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    private <R> CompletableFuture<R> executeOnOneNode(ClusterNode targetNode, Class<? extends ComputeJob<R>> jobClass, Object[] args) {
        if (this.isLocal(targetNode)) {
            return this.computeComponent.executeLocally(jobClass, args);
        }
        return this.computeComponent.executeRemotely(targetNode, jobClass, args);
    }

    private <R> CompletableFuture<R> executeOnOneNode(ClusterNode targetNode, String jobClassName, Object[] args) {
        if (this.isLocal(targetNode)) {
            return this.computeComponent.executeLocally(jobClassName, args);
        }
        return this.computeComponent.executeRemotely(targetNode, jobClassName, args);
    }

    private boolean isLocal(ClusterNode targetNode) {
        return targetNode.equals((Object)this.topologyService.localMember());
    }

    public <R> CompletableFuture<R> executeColocated(String tableName, Tuple key, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(key);
        Objects.requireNonNull(jobClass);
        return ((CompletableFuture)this.requiredTable(tableName).thenApply(table -> this.leaderOfTablePartitionByTupleKey((TableImpl)table, key))).thenCompose(primaryNode -> this.executeOnOneNode((ClusterNode)primaryNode, jobClass, args));
    }

    public <K, R> CompletableFuture<R> executeColocated(String tableName, K key, Mapper<K> keyMapper, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(key);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(jobClass);
        return ((CompletableFuture)this.requiredTable(tableName).thenApply(table -> this.leaderOfTablePartitionByMappedKey((TableImpl)table, key, keyMapper))).thenCompose(primaryNode -> this.executeOnOneNode((ClusterNode)primaryNode, jobClass, args));
    }

    public <R> CompletableFuture<R> executeColocated(String tableName, Tuple key, String jobClassName, Object ... args) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(key);
        Objects.requireNonNull(jobClassName);
        return ((CompletableFuture)this.requiredTable(tableName).thenApply(table -> this.leaderOfTablePartitionByTupleKey((TableImpl)table, key))).thenCompose(primaryNode -> this.executeOnOneNode((ClusterNode)primaryNode, jobClassName, args));
    }

    public <K, R> CompletableFuture<R> executeColocated(String tableName, K key, Mapper<K> keyMapper, String jobClassName, Object ... args) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(key);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(jobClassName);
        return ((CompletableFuture)this.requiredTable(tableName).thenApply(table -> this.leaderOfTablePartitionByMappedKey((TableImpl)table, key, keyMapper))).thenCompose(primaryNode -> this.executeOnOneNode((ClusterNode)primaryNode, jobClassName, args));
    }

    private CompletableFuture<TableImpl> requiredTable(String tableName) {
        String parsedName = IgniteNameUtils.parseSimpleName((String)tableName);
        return this.tables.tableImplAsync(parsedName).thenApply(table -> {
            if (table == null) {
                throw new TableNotFoundException(DEFAULT_SCHEMA_NAME, parsedName);
            }
            return table;
        });
    }

    private ClusterNode leaderOfTablePartitionByTupleKey(TableImpl table, Tuple key) {
        return this.requiredLeaderByPartition(table, table.partition(key));
    }

    private <K> ClusterNode leaderOfTablePartitionByMappedKey(TableImpl table, K key, Mapper<K> keyMapper) {
        return this.requiredLeaderByPartition(table, table.partition(key, keyMapper));
    }

    private ClusterNode requiredLeaderByPartition(TableImpl table, int partitionIndex) {
        ClusterNode leaderNode = table.leaderAssignment(partitionIndex);
        if (leaderNode == null) {
            throw new IgniteInternalException("Leader not found for partition " + partitionIndex);
        }
        return leaderNode;
    }

    public <R> Map<ClusterNode, CompletableFuture<R>> broadcast(Set<ClusterNode> nodes, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        Objects.requireNonNull(nodes);
        Objects.requireNonNull(jobClass);
        return nodes.stream().collect(Collectors.toUnmodifiableMap(node -> node, node -> this.executeOnOneNode((ClusterNode)node, jobClass, args)));
    }

    public <R> Map<ClusterNode, CompletableFuture<R>> broadcast(Set<ClusterNode> nodes, String jobClassName, Object ... args) {
        Objects.requireNonNull(nodes);
        Objects.requireNonNull(jobClassName);
        return nodes.stream().collect(Collectors.toUnmodifiableMap(node -> node, node -> this.executeOnOneNode((ClusterNode)node, jobClassName, args)));
    }
}

