/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index;

import java.util.List;
import org.apache.ignite.internal.binarytuple.BinaryTupleCommon;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.VarlenNativeType;
import org.apache.ignite.internal.storage.index.IndexDescriptor;

public class InlineUtils {
    public static final int MAX_BINARY_TUPLE_INLINE_SIZE = 2048;
    static final int MAX_VARLEN_INLINE_SIZE = 64;
    static final int MAX_BINARY_TUPLE_OFFSET_TABLE_ENTRY_SIZE = 2;
    static final int MIN_INNER_PAGE_ITEM_COUNT = 2;
    static final int BIG_NUMBER_INLINE_SIZE = 4;

    static int inlineSize(NativeType nativeType) {
        NativeTypeSpec spec = nativeType.spec();
        if (spec.fixedLength()) {
            return nativeType.sizeInBytes();
        }
        switch (spec) {
            case STRING: 
            case BYTES: {
                return Math.min(64, ((VarlenNativeType)nativeType).length());
            }
            case DECIMAL: 
            case NUMBER: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unknown type " + spec);
    }

    static int binaryTupleInlineSize(IndexDescriptor indexDescriptor) {
        List columns = indexDescriptor.columns();
        assert (!columns.isEmpty());
        boolean hasNullColumns = columns.stream().anyMatch(IndexDescriptor.ColumnDescriptor::nullable);
        int columnsInlineSize = columns.stream().map(IndexDescriptor.ColumnDescriptor::type).mapToInt(InlineUtils::inlineSize).sum();
        int inlineSize = 1 + (hasNullColumns ? BinaryTupleCommon.nullMapSize((int)columns.size()) : 0) + columns.size() * Math.min(2, BinaryTupleCommon.valueSizeToEntrySize((long)columnsInlineSize)) + columnsInlineSize;
        return Math.min(inlineSize, 2048);
    }

    public static int binaryTupleInlineSize(int pageSize, int itemHeaderSize, IndexDescriptor indexDescriptor) {
        int maxInnerNodeItemSize = (InlineUtils.innerNodePayloadSize(pageSize) - 6) / 2 - 6;
        int binaryTupleInlineSize = Math.min(maxInnerNodeItemSize - itemHeaderSize, InlineUtils.binaryTupleInlineSize(indexDescriptor));
        if (binaryTupleInlineSize >= 2048) {
            return 2048;
        }
        if (indexDescriptor.columns().stream().anyMatch(c -> !c.type().spec().fixedLength())) {
            int itemSize = binaryTupleInlineSize + itemHeaderSize;
            int innerNodeItemSize = InlineUtils.optimizeItemSize(InlineUtils.innerNodePayloadSize(pageSize) - 6, itemSize + 6) - 6;
            int leafNodeItemSize = InlineUtils.optimizeItemSize(InlineUtils.leafNodePayloadSize(pageSize), itemSize);
            int optimizedItemSize = Math.min(innerNodeItemSize, leafNodeItemSize);
            assert (InlineUtils.leafNodePayloadSize(pageSize) / itemSize == InlineUtils.leafNodePayloadSize(pageSize) / optimizedItemSize);
            binaryTupleInlineSize = optimizedItemSize - itemHeaderSize;
        }
        return Math.min(binaryTupleInlineSize, 2048);
    }

    static int innerNodePayloadSize(int pageSize) {
        return pageSize - 56;
    }

    static int leafNodePayloadSize(int pageSize) {
        return pageSize - 56;
    }

    static int optimizeItemSize(int nodePayloadSize, int itemSize) {
        int remainingNodePayloadSize = nodePayloadSize % itemSize;
        int nodeItemCount = nodePayloadSize / itemSize;
        int additionalNodeItemBytes = remainingNodePayloadSize / nodeItemCount;
        return itemSize + additionalNodeItemBytes;
    }

    public static boolean canFullyInline(int indexColumnsSize, int inlineSize) {
        return indexColumnsSize <= inlineSize + 6;
    }
}

