/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.index.IndexManager;
import org.apache.ignite.internal.index.event.IndexEvent;
import org.apache.ignite.internal.index.event.IndexEventParameters;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.Event;
import org.apache.ignite.internal.manager.EventListener;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.sql.engine.AsyncCloseable;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursorImpl;
import org.apache.ignite.internal.sql.engine.QueryCancel;
import org.apache.ignite.internal.sql.engine.QueryContext;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.QueryValidator;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.ArrayRowHandler;
import org.apache.ignite.internal.sql.engine.exec.ExchangeServiceImpl;
import org.apache.ignite.internal.sql.engine.exec.ExecutionService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionServiceImpl;
import org.apache.ignite.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistryImpl;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutorImpl;
import org.apache.ignite.internal.sql.engine.message.MessageServiceImpl;
import org.apache.ignite.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite.internal.sql.engine.prepare.PrepareServiceImpl;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.property.PropertiesHolder;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManagerImpl;
import org.apache.ignite.internal.sql.engine.session.Session;
import org.apache.ignite.internal.sql.engine.session.SessionId;
import org.apache.ignite.internal.sql.engine.session.SessionInfo;
import org.apache.ignite.internal.sql.engine.session.SessionManager;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.table.event.TableEvent;
import org.apache.ignite.internal.table.event.TableEventParameters;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.TopologyEventHandler;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQueryProcessor
implements QueryProcessor {
    private static final IgniteLogger LOG = Loggers.forClass(SqlQueryProcessor.class);
    private static final long PLANNER_TIMEOUT = 15000L;
    public static final int PLAN_CACHE_SIZE = 1024;
    public static final long SESSION_EXPIRE_CHECK_PERIOD = TimeUnit.SECONDS.toMillis(1L);
    public static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private final List<LifecycleAware> services = new ArrayList<LifecycleAware>();
    private final ClusterService clusterSrvc;
    private final TableManager tableManager;
    private final IndexManager indexManager;
    private final SchemaManager schemaManager;
    private final Consumer<Function<Long, CompletableFuture<?>>> registry;
    private final DataStorageManager dataStorageManager;
    private final Supplier<Map<String, Map<String, Class<?>>>> dataStorageFieldsSupplier;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final List<Pair<Event, EventListener>> evtLsnrs = new ArrayList<Pair<Event, EventListener>>();
    private volatile SessionManager sessionManager;
    private volatile QueryTaskExecutor taskExecutor;
    private volatile ExecutionService executionSrvc;
    private volatile PrepareService prepareSvc;
    private volatile SqlSchemaManager sqlSchemaManager;
    private final TxManager txManager;
    private final HybridClock clock;

    public SqlQueryProcessor(Consumer<Function<Long, CompletableFuture<?>>> registry, ClusterService clusterSrvc, TableManager tableManager, IndexManager indexManager, SchemaManager schemaManager, DataStorageManager dataStorageManager, TxManager txManager, Supplier<Map<String, Map<String, Class<?>>>> dataStorageFieldsSupplier, HybridClock clock) {
        this.registry = registry;
        this.clusterSrvc = clusterSrvc;
        this.tableManager = tableManager;
        this.indexManager = indexManager;
        this.schemaManager = schemaManager;
        this.dataStorageManager = dataStorageManager;
        this.txManager = txManager;
        this.dataStorageFieldsSupplier = dataStorageFieldsSupplier;
        this.clock = clock;
    }

    public synchronized void start() {
        String nodeName = this.clusterSrvc.topologyService().localMember().name();
        this.sessionManager = this.registerService(new SessionManager(nodeName, SESSION_EXPIRE_CHECK_PERIOD, System::currentTimeMillis));
        this.taskExecutor = this.registerService(new QueryTaskExecutorImpl(nodeName));
        MailboxRegistryImpl mailboxRegistry = this.registerService(new MailboxRegistryImpl());
        PrepareServiceImpl prepareSvc = this.registerService(PrepareServiceImpl.create(nodeName, 1024, this.dataStorageManager, this.dataStorageFieldsSupplier.get()));
        MessageServiceImpl msgSrvc = this.registerService(new MessageServiceImpl(this.clusterSrvc.topologyService(), this.clusterSrvc.messagingService(), this.taskExecutor, this.busyLock));
        ExchangeServiceImpl exchangeService = this.registerService(new ExchangeServiceImpl(this.clusterSrvc.topologyService().localMember(), this.taskExecutor, mailboxRegistry, msgSrvc));
        SqlSchemaManagerImpl sqlSchemaManager = new SqlSchemaManagerImpl(this.tableManager, this.schemaManager, this.registry, this.busyLock);
        sqlSchemaManager.registerListener(prepareSvc);
        this.prepareSvc = prepareSvc;
        ExecutionServiceImpl<Object[]> executionSrvc = this.registerService(ExecutionServiceImpl.create(this.clusterSrvc.topologyService(), msgSrvc, sqlSchemaManager, this.tableManager, this.indexManager, this.taskExecutor, ArrayRowHandler.INSTANCE, mailboxRegistry, exchangeService, this.dataStorageManager));
        this.clusterSrvc.topologyService().addEventHandler(executionSrvc);
        this.clusterSrvc.topologyService().addEventHandler((TopologyEventHandler)mailboxRegistry);
        this.executionSrvc = executionSrvc;
        this.registerTableListener(TableEvent.CREATE, new TableCreatedListener(sqlSchemaManager));
        this.registerTableListener(TableEvent.ALTER, new TableUpdatedListener(sqlSchemaManager));
        this.registerTableListener(TableEvent.DROP, new TableDroppedListener(sqlSchemaManager));
        this.registerIndexListener(IndexEvent.CREATE, new IndexCreatedListener(sqlSchemaManager));
        this.registerIndexListener(IndexEvent.DROP, new IndexDroppedListener(sqlSchemaManager));
        this.sqlSchemaManager = sqlSchemaManager;
        this.services.forEach(LifecycleAware::start);
    }

    @Override
    public SessionId createSession(long sessionTimeoutMs, PropertiesHolder queryProperties) {
        return this.sessionManager.createSession(sessionTimeoutMs, queryProperties);
    }

    @Override
    public CompletableFuture<Void> closeSession(SessionId sessionId) {
        Session session = this.sessionManager.session(sessionId);
        if (session == null) {
            return CompletableFuture.completedFuture(null);
        }
        return session.closeAsync();
    }

    @Override
    public List<SessionInfo> liveSessions() {
        return this.sessionManager.liveSessions();
    }

    public synchronized void stop() throws Exception {
        this.busyLock.block();
        ArrayList<LifecycleAware> services = new ArrayList<LifecycleAware>(this.services);
        this.services.clear();
        Collections.reverse(services);
        Stream<AutoCloseable> closableComponents = services.stream().map(s -> s::stop);
        Stream<AutoCloseable> closableListeners = this.evtLsnrs.stream().map(p -> () -> {
            if (p.left instanceof TableEvent) {
                this.tableManager.removeListener((Event)((TableEvent)p.left), (EventListener)p.right);
            } else {
                this.indexManager.removeListener((Event)((IndexEvent)p.left), (EventListener)p.right);
            }
        });
        IgniteUtils.closeAll((Collection)Stream.concat(closableComponents, closableListeners).collect(Collectors.toList()));
    }

    @Override
    public List<CompletableFuture<AsyncSqlCursor<List<Object>>>> queryAsync(String schemaName, String qry, Object ... params) {
        return this.queryAsync(QueryContext.of(new Object[0]), schemaName, qry, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CompletableFuture<AsyncSqlCursor<List<Object>>>> queryAsync(QueryContext context, String schemaName, String qry, Object ... params) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Sql.OPERATION_INTERRUPTED_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            List<CompletableFuture<AsyncSqlCursor<List<Object>>>> list = this.query0(context, schemaName, qry, params);
            return list;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AsyncSqlCursor<List<Object>>> querySingleAsync(SessionId sessionId, QueryContext context, String qry, Object ... params) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Sql.OPERATION_INTERRUPTED_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<AsyncSqlCursor<List<Object>>> completableFuture = this.querySingle0(sessionId, context, qry, params);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private <T extends LifecycleAware> T registerService(T service) {
        this.services.add(service);
        return service;
    }

    private void registerTableListener(TableEvent evt, AbstractTableEventListener lsnr) {
        this.evtLsnrs.add((Pair<Event, EventListener>)Pair.of((Object)evt, (Object)lsnr));
        this.tableManager.listen((Event)evt, (EventListener)lsnr);
    }

    private void registerIndexListener(IndexEvent evt, AbstractIndexEventListener lsnr) {
        this.evtLsnrs.add((Pair<Event, EventListener>)Pair.of((Object)evt, (Object)lsnr));
        this.indexManager.listen((Event)evt, (EventListener)lsnr);
    }

    private CompletableFuture<AsyncSqlCursor<List<Object>>> querySingle0(SessionId sessionId, QueryContext context, String sql, Object ... params) {
        final Session session = this.sessionManager.session(sessionId);
        if (session == null) {
            return CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.SESSION_NOT_FOUND_ERR, IgniteStringFormatter.format((String)"Session not found [{}]", (Object[])new Object[]{sessionId})));
        }
        String schemaName = session.queryProperties().get(QueryProperty.DEFAULT_SCHEMA);
        SchemaPlus schema = this.sqlSchemaManager.schema(schemaName);
        if (schema == null) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Sql.SCHEMA_NOT_FOUND_ERR, IgniteStringFormatter.format((String)"Schema not found [schemaName={}]", (Object[])new Object[]{schemaName})));
        }
        InternalTransaction outerTx = context.unwrap(InternalTransaction.class);
        QueryCancel queryCancel = new QueryCancel();
        AsyncCloseable closeableResource = () -> CompletableFuture.runAsync(queryCancel::cancel, this.taskExecutor);
        queryCancel.add(() -> session.unregisterResource(closeableResource));
        try {
            session.registerResource(closeableResource);
        }
        catch (IllegalStateException ex2) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Sql.SESSION_EXPIRED_ERR, IgniteStringFormatter.format((String)"Session has been expired [{}]", (Object[])new Object[]{session.sessionId()}), (Throwable)ex2));
        }
        CompletableFuture<Void> start = new CompletableFuture<Void>();
        CompletionStage stage = ((CompletableFuture)start.thenApply(v -> {
            SqlNodeList nodes = Commons.parse(sql, Commons.PARSER_CONFIG);
            if (nodes.size() > 1) {
                throw new SqlException(ErrorGroups.Sql.QUERY_INVALID_ERR, "Multiple statements aren't allowed.");
            }
            return nodes.get(0);
        })).thenCompose(sqlNode -> {
            boolean rwOp = SqlQueryProcessor.dataModificationOp(sqlNode);
            HybridTimestamp txTime = outerTx != null ? outerTx.readTimestamp() : (rwOp ? null : this.clock.now());
            BaseQueryContext ctx = BaseQueryContext.builder().frameworkConfig(Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(schema).traitDefs(rwOp || outerTx != null && !outerTx.isReadOnly() ? Commons.LOCAL_TRAITS_SET : Commons.DISTRIBUTED_TRAITS_SET).build()).logger(LOG).cancel(queryCancel).parameters(params).transaction(outerTx).transactionTime(txTime).plannerTimeout(15000L).build();
            return this.prepareSvc.prepareAsync((SqlNode)sqlNode, ctx).thenApply(plan -> {
                context.maybeUnwrap(QueryValidator.class).ifPresent(queryValidator -> queryValidator.validatePlan((QueryPlan)plan));
                boolean implicitTxRequired = outerTx == null && rwOp;
                InternalTransaction implicitTx = implicitTxRequired ? this.txManager.begin() : null;
                BaseQueryContext enrichedContext = implicitTxRequired ? ctx.toBuilder().transaction(implicitTx).build() : ctx;
                final AsyncCursor<List<Object>> dataCursor = this.executionSrvc.executePlan((QueryPlan)plan, enrichedContext);
                return new AsyncSqlCursorImpl<List<Object>>(SqlQueryType.mapPlanTypeToSqlType(plan.type()), plan.metadata(), implicitTx, new AsyncCursor<List<Object>>(){

                    @Override
                    public CompletableFuture<AsyncCursor.BatchedResult<List<Object>>> requestNextAsync(int rows) {
                        session.touch();
                        return dataCursor.requestNextAsync(rows);
                    }

                    @Override
                    public CompletableFuture<Void> closeAsync() {
                        session.touch();
                        return dataCursor.closeAsync();
                    }
                });
            });
        });
        ((CompletableFuture)stage).whenComplete((cur, ex) -> {
            if (ex instanceof CancellationException) {
                queryCancel.cancel();
            }
        });
        start.completeAsync(() -> null, this.taskExecutor);
        return stage;
    }

    private List<CompletableFuture<AsyncSqlCursor<List<Object>>>> query0(QueryContext context, String schemaName, String sql, Object ... params) {
        SchemaPlus schema = this.sqlSchemaManager.schema(schemaName);
        if (schema == null) {
            throw new IgniteInternalException(ErrorGroups.Sql.SCHEMA_NOT_FOUND_ERR, IgniteStringFormatter.format((String)"Schema not found [schemaName={}]", (Object[])new Object[]{schemaName}));
        }
        SqlNodeList nodes = Commons.parse(sql, Commons.FRAMEWORK_CONFIG.getParserConfig());
        ArrayList<CompletableFuture<AsyncSqlCursor<List<Object>>>> res = new ArrayList<CompletableFuture<AsyncSqlCursor<List<Object>>>>(nodes.size());
        CompletableFuture<Void> start = new CompletableFuture<Void>();
        for (SqlNode sqlNode : nodes) {
            boolean needStartTx = SqlKind.DML.contains(sqlNode.getKind()) || SqlKind.QUERY.contains(sqlNode.getKind());
            InternalTransaction implicitTx = needStartTx ? this.txManager.begin() : null;
            BaseQueryContext ctx = BaseQueryContext.builder().cancel(new QueryCancel()).frameworkConfig(Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).traitDefs(needStartTx ? Commons.LOCAL_TRAITS_SET : Commons.DISTRIBUTED_TRAITS_SET).defaultSchema(schema).build()).logger(LOG).parameters(params).plannerTimeout(15000L).transaction(implicitTx).build();
            CompletionStage stage = ((CompletableFuture)start.thenCompose(none -> this.prepareSvc.prepareAsync(sqlNode, ctx))).thenApply(plan -> {
                context.maybeUnwrap(QueryValidator.class).ifPresent(queryValidator -> queryValidator.validatePlan((QueryPlan)plan));
                return new AsyncSqlCursorImpl<List<Object>>(SqlQueryType.mapPlanTypeToSqlType(plan.type()), plan.metadata(), implicitTx, this.executionSrvc.executePlan((QueryPlan)plan, ctx));
            });
            ((CompletableFuture)stage).whenComplete((cur, ex) -> {
                if (ex instanceof CancellationException) {
                    ctx.cancel().cancel();
                }
            });
            res.add((CompletableFuture<AsyncSqlCursor<List<Object>>>)stage);
        }
        start.completeAsync(() -> null, this.taskExecutor);
        return res;
    }

    private static boolean dataModificationOp(SqlNode sqlNode) {
        return SqlKind.DML.contains(sqlNode.getKind());
    }

    private static class IndexCreatedListener
    extends AbstractIndexEventListener {
        private IndexCreatedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public CompletableFuture<Boolean> notify(@NotNull IndexEventParameters parameters, @Nullable Throwable exception) {
            return this.schemaHolder.onIndexCreated(parameters.index(), parameters.causalityToken()).thenApply(v -> false);
        }
    }

    private static class IndexDroppedListener
    extends AbstractIndexEventListener {
        private IndexDroppedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public CompletableFuture<Boolean> notify(@NotNull IndexEventParameters parameters, @Nullable Throwable exception) {
            return this.schemaHolder.onIndexDropped(SqlQueryProcessor.DEFAULT_SCHEMA_NAME, parameters.indexId(), parameters.causalityToken()).thenApply(v -> false);
        }
    }

    private static class TableDroppedListener
    extends AbstractTableEventListener {
        private TableDroppedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public CompletableFuture<Boolean> notify(@NotNull TableEventParameters parameters, @Nullable Throwable exception) {
            return this.schemaHolder.onTableDropped(SqlQueryProcessor.DEFAULT_SCHEMA_NAME, parameters.tableName(), parameters.causalityToken()).thenApply(v -> false);
        }
    }

    private static class TableUpdatedListener
    extends AbstractTableEventListener {
        private TableUpdatedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public CompletableFuture<Boolean> notify(@NotNull TableEventParameters parameters, @Nullable Throwable exception) {
            return this.schemaHolder.onTableUpdated(SqlQueryProcessor.DEFAULT_SCHEMA_NAME, parameters.table(), parameters.causalityToken()).thenApply(v -> false);
        }
    }

    private static class TableCreatedListener
    extends AbstractTableEventListener {
        private TableCreatedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public CompletableFuture<Boolean> notify(@NotNull TableEventParameters parameters, @Nullable Throwable exception) {
            return this.schemaHolder.onTableCreated(SqlQueryProcessor.DEFAULT_SCHEMA_NAME, parameters.table(), parameters.causalityToken()).thenApply(v -> false);
        }
    }

    private static abstract class AbstractIndexEventListener
    implements EventListener<IndexEventParameters> {
        protected final SqlSchemaManagerImpl schemaHolder;

        private AbstractIndexEventListener(SqlSchemaManagerImpl schemaHolder) {
            this.schemaHolder = schemaHolder;
        }
    }

    private static abstract class AbstractTableEventListener
    implements EventListener<TableEventParameters> {
        protected final SqlSchemaManagerImpl schemaHolder;

        private AbstractTableEventListener(SqlSchemaManagerImpl schemaHolder) {
            this.schemaHolder = schemaHolder;
        }
    }
}

