/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import org.apache.ignite.internal.sql.engine.message.ErrorMessage;
import org.apache.ignite.internal.sql.engine.message.ErrorMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class ErrorMessageDeserializer
implements MessageDeserializer<ErrorMessage> {
    private final ErrorMessageBuilder msg;

    ErrorMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.errorMessage();
    }

    public Class<ErrorMessage> klass() {
        return ErrorMessage.class;
    }

    public ErrorMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.errorByteArray(reader.readByteArray("errorByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.fragmentId(reader.readLong("fragmentId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.queryId(reader.readUuid("queryId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ErrorMessage.class);
    }
}

