/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity.codec.v1;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite.raft.jraft.util.Bits;

public final class V1Decoder
implements LogEntryDecoder {
    public static final V1Decoder INSTANCE = new V1Decoder();

    private V1Decoder() {
    }

    @Override
    public LogEntry decode(byte[] content) {
        if (content == null || content.length == 0) {
            return null;
        }
        if (content[0] != -72) {
            return null;
        }
        LogEntry log = new LogEntry();
        this.decode(log, content);
        return log;
    }

    public void decode(LogEntry log, byte[] content) {
        int iType = Bits.getInt(content, 1);
        log.setType(EnumOutter.EntryType.forNumber(iType));
        long index = Bits.getLong(content, 5);
        long term = Bits.getLong(content, 13);
        log.setId(new LogId(index, term));
        log.setChecksum(Bits.getLong(content, 21));
        int peerCount = Bits.getInt(content, 29);
        int pos = 33;
        if (peerCount > 0) {
            ArrayList<PeerId> peers = new ArrayList<PeerId>(peerCount);
            while (peerCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                peers.add(peer);
            }
            log.setPeers(peers);
        }
        int oldPeerCount = Bits.getInt(content, pos);
        pos += 4;
        if (oldPeerCount > 0) {
            ArrayList<PeerId> oldPeers = new ArrayList<PeerId>(oldPeerCount);
            while (oldPeerCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                oldPeers.add(peer);
            }
            log.setOldPeers(oldPeers);
        }
        int learnersCount = Bits.getInt(content, pos);
        pos += 4;
        if (learnersCount > 0) {
            ArrayList<PeerId> learners = new ArrayList<PeerId>(learnersCount);
            while (learnersCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                learners.add(peer);
            }
            log.setLearners(learners);
        }
        int oldLearnersCount = Bits.getInt(content, pos);
        pos += 4;
        if (oldLearnersCount > 0) {
            ArrayList<PeerId> oldLearners = new ArrayList<PeerId>(oldLearnersCount);
            while (oldLearnersCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                oldLearners.add(peer);
            }
            log.setOldLearners(oldLearners);
        }
        if (content.length > pos) {
            int len = content.length - pos;
            ByteBuffer data = ByteBuffer.allocate(len);
            data.put(content, pos, len);
            data.flip();
            log.setData(data);
        }
    }
}

