/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity.codec.v1;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite.raft.jraft.util.Bits;

public final class V1Encoder
implements LogEntryEncoder {
    public static final LogEntryEncoder INSTANCE = new V1Encoder();

    private V1Encoder() {
    }

    @Override
    public byte[] encode(LogEntry log) {
        byte[] ps;
        EnumOutter.EntryType type = log.getType();
        LogId id = log.getId();
        List<PeerId> peers = log.getPeers();
        List<PeerId> oldPeers = log.getOldPeers();
        List<PeerId> learners = log.getLearners();
        List<PeerId> oldLearners = log.getOldLearners();
        ByteBuffer data = log.getData();
        int totalLen = 1;
        int iType = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        totalLen += 28;
        int peerCount = 0;
        totalLen += 4;
        ArrayList<Object> peerStrs = new ArrayList<Object>();
        if (peers != null) {
            peerCount = peers.size();
            for (PeerId peer : peers) {
                String peerStr = peer.toString();
                totalLen += 2 + peerStr.length();
                peerStrs.add(peerStr);
            }
        }
        int oldPeerCount = 0;
        totalLen += 4;
        ArrayList<Object> oldPeerStrs = new ArrayList<Object>();
        if (oldPeers != null) {
            oldPeerCount = oldPeers.size();
            for (PeerId peer : oldPeers) {
                String peerStr = peer.toString();
                totalLen += 2 + peerStr.length();
                oldPeerStrs.add(peerStr);
            }
        }
        int learnerCount = 0;
        totalLen += 4;
        ArrayList<Object> learnerStrs = new ArrayList<Object>();
        if (learners != null) {
            learnerCount = learners.size();
            for (PeerId learner : learners) {
                String learnerStr = learner.toString();
                totalLen += 2 + learnerStr.length();
                learnerStrs.add(learnerStr);
            }
        }
        int oldLearnerCount = 0;
        totalLen += 4;
        ArrayList<String> oldLearnerStrs = new ArrayList<String>();
        if (oldLearners != null) {
            oldLearnerCount = oldLearners.size();
            for (PeerId oldLearner : oldLearners) {
                String learnerStr = oldLearner.toString();
                totalLen += 2 + learnerStr.length();
                oldLearnerStrs.add(learnerStr);
            }
        }
        int bodyLen = data != null ? data.remaining() : 0;
        byte[] content = new byte[totalLen += bodyLen];
        content[0] = -72;
        Bits.putInt(content, 1, iType);
        Bits.putLong(content, 5, index);
        Bits.putLong(content, 13, term);
        Bits.putLong(content, 21, log.getChecksum());
        Bits.putInt(content, 29, peerCount);
        int pos = 33;
        for (String string : peerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        Bits.putInt(content, pos, oldPeerCount);
        pos += 4;
        for (String string : oldPeerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        Bits.putInt(content, pos, learnerCount);
        pos += 4;
        for (String string : learnerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        Bits.putInt(content, pos, oldLearnerCount);
        pos += 4;
        for (String string : oldLearnerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        if (data != null) {
            System.arraycopy(data.array(), data.position(), content, pos, data.remaining());
        }
        return content;
    }
}

