/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.ResetPeerRequestBuilder;

class ResetPeerRequestDeserializer
implements MessageDeserializer<CliRequests.ResetPeerRequest> {
    private final ResetPeerRequestBuilder msg;

    ResetPeerRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.resetPeerRequest();
    }

    public Class<CliRequests.ResetPeerRequest> klass() {
        return CliRequests.ResetPeerRequest.class;
    }

    public CliRequests.ResetPeerRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.groupId(reader.readString("groupId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.newPeersList(reader.readCollection("newPeersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.oldPeersList(reader.readCollection("oldPeersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.peerId(reader.readString("peerId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CliRequests.ResetPeerRequest.class);
    }
}

