/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.view.RapidocConfig;
import io.micronaut.openapi.view.RedocConfig;
import io.micronaut.openapi.view.Renderer;
import io.micronaut.openapi.view.SwaggerUIConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class OpenApiViewConfig {
    private static final String TEMPLATES = "templates";
    private static final String TEMPLATES_SWAGGER_UI = "swagger-ui";
    private static final String TEMPLATES_REDOC = "redoc";
    private static final String TEMPLATES_RAPIDOC = "rapidoc";
    private static final String TEMPLATE_INDEX_HTML = "index.html";
    private static final String REDOC = "redoc";
    private static final String RAPIDOC = "rapidoc";
    private static final String SWAGGER_UI = "swagger-ui";
    private static final String TEMPLATE_OAUTH_2_REDIRECT_HTML = "oauth2-redirect.html";
    private static final String SLASH = "/";
    private String mappingPath;
    private String title;
    private String specFile;
    private String serverContextPath = "";
    private SwaggerUIConfig swaggerUIConfig;
    private RedocConfig redocConfig;
    private RapidocConfig rapidocConfig;

    private OpenApiViewConfig() {
    }

    private static Map<String, String> parse(String specification) {
        if (specification == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(specification.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> s.split("=")).filter(keyValue -> ((String[])keyValue).length == 2).peek(keyValue -> {
            keyValue[0] = keyValue[0].trim();
            keyValue[1] = keyValue[1].trim();
        }).filter(keyValue -> !keyValue[0].isEmpty() && !keyValue[1].isEmpty()).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1]));
    }

    public static OpenApiViewConfig fromSpecification(String specification, Properties openApiProperties) {
        HashMap<String, String> openApiMap = new HashMap<String, String>(openApiProperties.size());
        openApiProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> openApiMap.put((String)key, (String)value)));
        openApiMap.putAll(OpenApiViewConfig.parse(specification));
        OpenApiViewConfig cfg = new OpenApiViewConfig();
        RapiPDFConfig rapiPDFConfig = RapiPDFConfig.fromProperties(openApiMap);
        if ("true".equals(openApiMap.getOrDefault("redoc.enabled", Boolean.FALSE.toString()))) {
            cfg.redocConfig = RedocConfig.fromProperties(openApiMap);
            cfg.redocConfig.rapiPDFConfig = rapiPDFConfig;
        }
        if ("true".equals(openApiMap.getOrDefault("rapidoc.enabled", Boolean.FALSE.toString()))) {
            cfg.rapidocConfig = RapidocConfig.fromProperties(openApiMap);
            cfg.rapidocConfig.rapiPDFConfig = rapiPDFConfig;
        }
        if ("true".equals(openApiMap.getOrDefault("swagger-ui.enabled", Boolean.FALSE.toString()))) {
            cfg.swaggerUIConfig = SwaggerUIConfig.fromProperties(openApiMap);
            cfg.swaggerUIConfig.rapiPDFConfig = rapiPDFConfig;
        }
        cfg.mappingPath = openApiMap.getOrDefault("mapping.path", "swagger");
        return cfg;
    }

    public boolean isEnabled() {
        return this.redocConfig != null || this.rapidocConfig != null || this.swaggerUIConfig != null;
    }

    public void render(Path outputDir, VisitorContext visitorContext) throws IOException {
        if (this.redocConfig != null) {
            this.render(this.redocConfig, outputDir.resolve("redoc"), "templates/redoc/index.html", visitorContext);
        }
        if (this.rapidocConfig != null) {
            this.render(this.rapidocConfig, outputDir.resolve("rapidoc"), "templates/rapidoc/index.html", visitorContext);
        }
        if (this.swaggerUIConfig != null) {
            Path dir = outputDir.resolve("swagger-ui");
            this.render(this.swaggerUIConfig, dir, "templates/swagger-ui/index.html", visitorContext);
            if (SwaggerUIConfig.hasOauth2Option(this.swaggerUIConfig.options)) {
                this.render(this.swaggerUIConfig, dir, "templates/swagger-ui/oauth2-redirect.html", visitorContext);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String readTemplateFromClasspath(String templateName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void render(Renderer renderer, Path outputDir, String templateName, VisitorContext visitorContext) throws IOException {
        String template = this.readTemplateFromClasspath(templateName);
        template = renderer.render(template);
        template = OpenApiViewConfig.replacePlaceHolder(template, "specURL", this.getSpecURL(), "");
        template = OpenApiViewConfig.replacePlaceHolder(template, "title", this.getTitle(), "");
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        String fileName = templateName.substring(templateName.lastIndexOf(SLASH) + 1);
        Path file = outputDir.resolve(fileName);
        if (visitorContext != null) {
            visitorContext.info("Writing OpenAPI View to destination: " + file);
            visitorContext.getClassesOutputPath().ifPresent(path -> visitorContext.addGeneratedResource(path.relativize(file).toString()));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(template);
        }
    }

    public void setServerContextPath(String contextPath) {
        this.serverContextPath = contextPath == null ? "" : contextPath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSpecURL() {
        return StringUtils.prependUri((String)this.serverContextPath, (String)StringUtils.prependUri((String)this.mappingPath, (String)this.specFile));
    }

    public void setSpecFile(String specFile) {
        this.specFile = specFile;
    }

    public String toString() {
        return new StringBuilder(100).append("OpenApiConfig [swaggerUIConfig=").append(this.swaggerUIConfig).append(", reDocConfig=").append(this.redocConfig).append(", rapiDocConfig=").append(this.rapidocConfig).append(']').toString();
    }

    static String replacePlaceHolder(String template, String placeHolder, String value, String valuePrefix) {
        if (value == null || value.isEmpty()) {
            return template.replace("{{" + placeHolder + "}}", "");
        }
        return template.replace("{{" + placeHolder + "}}", valuePrefix + value);
    }

    static enum RendererType {
        SWAGGER_UI,
        REDOC,
        RAPIDOC;

    }
}

