/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.network.OutNetworkObject;
import org.jetbrains.annotations.TestOnly;

public class NettySender {
    private final Channel channel;
    private final String launchId;
    private final String consistentId;

    public NettySender(Channel channel, String launchId, String consistentId) {
        this.channel = channel;
        this.launchId = launchId;
        this.consistentId = consistentId;
    }

    public CompletableFuture<Void> send(OutNetworkObject obj) {
        return NettyUtils.toCompletableFuture(this.channel.writeAndFlush((Object)obj));
    }

    public String launchId() {
        return this.launchId;
    }

    public String consistentId() {
        return this.consistentId;
    }

    public void close() {
        this.channel.close().awaitUninterruptibly();
    }

    public CompletableFuture<Void> closeAsync() {
        return NettyUtils.toCompletableFuture(this.channel.close());
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @TestOnly
    public Channel channel() {
        return this.channel;
    }
}

