/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.util.Objects;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.marshaller.FieldAccessor;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.internal.marshaller.MarshallerException;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerUtil;
import org.apache.ignite.internal.marshaller.MarshallerWriter;
import org.apache.ignite.internal.util.Factory;
import org.apache.ignite.internal.util.ObjectFactory;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.mapper.OneColumnMapper;
import org.apache.ignite.table.mapper.PojoMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Marshaller {
    public static <T> Marshaller createMarshaller(MarshallerColumn[] cols, @NotNull Mapper<T> mapper, boolean requireAllFields) {
        if (mapper instanceof OneColumnMapper) {
            return Marshaller.simpleMarshaller(cols, (OneColumnMapper)mapper);
        }
        if (mapper instanceof PojoMapper) {
            return Marshaller.pojoMarshaller(cols, (PojoMapper)mapper, requireAllFields);
        }
        throw new IllegalArgumentException("Mapper of unsupported type: " + mapper.getClass());
    }

    static <T> SimpleMarshaller simpleMarshaller(MarshallerColumn[] cols, @NotNull OneColumnMapper<T> mapper) {
        BinaryMode mode = MarshallerUtil.mode(mapper.targetType());
        MarshallerColumn col = cols[0];
        assert (cols.length == 1);
        assert (mode == col.type()) : "Target type is not compatible.";
        assert (!mapper.targetType().isPrimitive()) : "Non-nullable types are not allowed.";
        return new SimpleMarshaller(FieldAccessor.createIdentityAccessor(col.name(), 0, mode));
    }

    static <T> PojoMarshaller pojoMarshaller(MarshallerColumn[] cols, @NotNull PojoMapper<T> mapper, boolean requireAllFields) {
        FieldAccessor[] fieldAccessors = new FieldAccessor[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            MarshallerColumn col = cols[i];
            String fieldName = mapper.fieldForColumn(col.name());
            if (requireAllFields && fieldName == null) {
                throw new IllegalArgumentException("No field found for column " + col.name());
            }
            fieldAccessors[i] = fieldName == null ? FieldAccessor.noopAccessor(col) : FieldAccessor.create(mapper.targetType(), fieldName, col, i);
        }
        return new PojoMarshaller(new ObjectFactory(mapper.targetType()), fieldAccessors);
    }

    @Nullable
    public abstract Object value(Object var1, int var2);

    public abstract Object readObject(MarshallerReader var1, @Nullable Object var2) throws MarshallerException;

    public abstract void copyObject(Object var1, Object var2) throws MarshallerException;

    public abstract void writeObject(Object var1, MarshallerWriter var2) throws MarshallerException;

    private static class PojoMarshaller
    extends Marshaller {
        private final FieldAccessor[] fieldAccessors;
        private final Factory<?> factory;

        PojoMarshaller(Factory<?> factory, FieldAccessor[] fieldAccessors) {
            this.fieldAccessors = fieldAccessors;
            this.factory = Objects.requireNonNull(factory);
        }

        @Override
        @Nullable
        public Object value(Object obj, int fldIdx) {
            return this.fieldAccessors[fldIdx].value(obj);
        }

        @Override
        public Object readObject(MarshallerReader reader, Object target) throws MarshallerException {
            Object obj = target == null ? this.factory.create() : target;
            for (int fldIdx = 0; fldIdx < this.fieldAccessors.length; ++fldIdx) {
                this.fieldAccessors[fldIdx].read(reader, obj);
            }
            return obj;
        }

        @Override
        public void copyObject(Object source, Object target) throws MarshallerException {
            for (int fldIdx = 0; fldIdx < this.fieldAccessors.length; ++fldIdx) {
                FieldAccessor fieldAccessor = this.fieldAccessors[fldIdx];
                Object val = fieldAccessor.get(source);
                fieldAccessor.set(target, val);
            }
        }

        @Override
        public void writeObject(Object obj, MarshallerWriter writer) throws MarshallerException {
            for (int fldIdx = 0; fldIdx < this.fieldAccessors.length; ++fldIdx) {
                this.fieldAccessors[fldIdx].write(writer, obj);
            }
        }
    }

    private static class SimpleMarshaller
    extends Marshaller {
        private final FieldAccessor fieldAccessor;

        SimpleMarshaller(FieldAccessor fieldAccessor) {
            this.fieldAccessor = fieldAccessor;
        }

        @Override
        @Nullable
        public Object value(Object obj, int fldIdx) {
            assert (fldIdx == 0);
            return this.fieldAccessor.value(obj);
        }

        @Override
        public Object readObject(MarshallerReader reader, Object target) {
            return this.fieldAccessor.read(reader);
        }

        @Override
        public void copyObject(Object source, Object target) throws MarshallerException {
            throw new UnsupportedOperationException("SimpleMarshaller can't copy objects.");
        }

        @Override
        public void writeObject(Object obj, MarshallerWriter writer) throws MarshallerException {
            this.fieldAccessor.write(writer, obj);
        }
    }
}

