/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.rest.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum State {
    STARTING("STARTING"),
    STARTED("STARTED"),
    STOPPING("STOPPING");

    private String value;

    private State(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static State fromValue(String value) {
        for (State b : State.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<State> {
        public void write(JsonWriter jsonWriter, State enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public State read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return State.fromValue(value);
        }
    }
}

