/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.file.Path;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageEngine;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineConfiguration;
import org.jetbrains.annotations.Nullable;

public class RocksDbDataStorageModule
implements DataStorageModule {
    public String name() {
        return "rocksdb";
    }

    public StorageEngine createEngine(String igniteInstanceName, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector) throws StorageException {
        RocksDbStorageEngineConfiguration engineConfig = (RocksDbStorageEngineConfiguration)configRegistry.getConfiguration(RocksDbStorageEngineConfiguration.KEY);
        assert (engineConfig != null);
        return new RocksDbStorageEngine(engineConfig, storagePath);
    }
}

