/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot;

import java.util.UUID;

public class SnapshotUri {
    private static final int UUID_LENGTH = 36;
    public final UUID snapshotId;
    public final String nodeName;

    public static String toStringUri(UUID snapshotId, String nodeName) {
        return nodeName + "-" + snapshotId;
    }

    public static SnapshotUri fromStringUri(String uri) {
        UUID snapshotId = UUID.fromString(uri.substring(uri.length() - 36));
        String nodeName = uri.substring(0, uri.length() - 36 - 1);
        return new SnapshotUri(snapshotId, nodeName);
    }

    private SnapshotUri(UUID snapshotId, String nodeName) {
        this.snapshotId = snapshotId;
        this.nodeName = nodeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotUri that = (SnapshotUri)o;
        if (!this.snapshotId.equals(that.snapshotId)) {
            return false;
        }
        return this.nodeName.equals(that.nodeName);
    }

    public int hashCode() {
        int result = this.snapshotId.hashCode();
        result = 31 * result + this.nodeName.hashCode();
        return result;
    }

    public String toString() {
        return SnapshotUri.toStringUri(this.snapshotId, this.nodeName);
    }
}

