/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.util.TransformingIterator;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.NoRowSetExpectedException;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlException;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncResultSetImpl
implements AsyncResultSet {
    private static final CompletableFuture<? extends AsyncResultSet> HAS_NO_MORE_PAGE_FUTURE = CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.CURSOR_NO_MORE_PAGES_ERR, "There are no more pages."));
    private final AsyncSqlCursor<List<Object>> cur;
    private volatile AsyncCursor.BatchedResult<List<Object>> curPage;
    private final int pageSize;
    private final Runnable closeRun;

    public AsyncResultSetImpl(AsyncSqlCursor<List<Object>> cur, AsyncCursor.BatchedResult<List<Object>> page, int pageSize, Runnable closeRun) {
        this.cur = cur;
        this.curPage = page;
        this.pageSize = pageSize;
        this.closeRun = closeRun;
    }

    @Nullable
    public ResultSetMetadata metadata() {
        return this.hasRowSet() ? this.cur.metadata() : null;
    }

    public boolean hasRowSet() {
        return this.cur.queryType() == SqlQueryType.QUERY || this.cur.queryType() == SqlQueryType.EXPLAIN;
    }

    public long affectedRows() {
        if (this.cur.queryType() != SqlQueryType.DML) {
            return -1L;
        }
        assert (this.curPage.items().get(0).get(0) instanceof Long) : "Invalid DML result: " + this.curPage;
        return (Long)this.curPage.items().get(0).get(0);
    }

    public boolean wasApplied() {
        if (this.cur.queryType() != SqlQueryType.DDL) {
            return false;
        }
        assert (this.curPage.items().get(0).get(0) instanceof Boolean) : "Invalid DDL result: " + this.curPage;
        return (Boolean)this.curPage.items().get(0).get(0);
    }

    public Iterable<SqlRow> currentPage() {
        this.requireResultSet();
        Iterator<List<Object>> it0 = this.curPage.items().iterator();
        ResultSetMetadata meta0 = this.cur.metadata();
        return () -> new TransformingIterator(it0, item -> new SqlRowImpl((List<Object>)item, meta0));
    }

    public int currentPageSize() {
        this.requireResultSet();
        return this.curPage.items().size();
    }

    public CompletableFuture<? extends AsyncResultSet> fetchNextPage() {
        this.requireResultSet();
        if (!this.hasMorePages()) {
            return HAS_NO_MORE_PAGE_FUTURE;
        }
        return this.cur.requestNextAsync(this.pageSize).thenApply(page -> {
            this.curPage = page;
            return this;
        });
    }

    public boolean hasMorePages() {
        return this.curPage.hasMore();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.cur.closeAsync().thenRun(this.closeRun);
    }

    private void requireResultSet() {
        if (!this.hasRowSet()) {
            throw new NoRowSetExpectedException();
        }
    }

    private static class SqlRowImpl
    implements SqlRow {
        private final List<Object> row;
        private final ResultSetMetadata meta;

        SqlRowImpl(List<Object> row, ResultSetMetadata meta) {
            this.row = row;
            this.meta = meta;
        }

        public int columnCount() {
            return this.meta.columns().size();
        }

        public String columnName(int columnIndex) {
            return ((ColumnMetadata)this.meta.columns().get(columnIndex)).name();
        }

        public int columnIndex(@NotNull String columnName) {
            return this.meta.indexOf(columnName);
        }

        private int columnIndexChecked(@NotNull String columnName) {
            int idx = this.columnIndex(columnName);
            if (idx == -1) {
                throw new IllegalArgumentException("Column doesn't exist [name=" + columnName + "]");
            }
            return idx;
        }

        public <T> T valueOrDefault(@NotNull String columnName, T defaultValue) {
            Object ret = this.row.get(this.columnIndexChecked(columnName));
            return (T)(ret != null ? ret : defaultValue);
        }

        public Tuple set(@NotNull String columnName, Object value) {
            throw new UnsupportedOperationException("Operation not supported.");
        }

        public <T> T value(@NotNull String columnName) throws IllegalArgumentException {
            return (T)this.row.get(this.columnIndexChecked(columnName));
        }

        public <T> T value(int columnIndex) {
            return (T)this.row.get(columnIndex);
        }

        public BinaryObject binaryObjectValue(@NotNull String columnName) {
            return (BinaryObject)this.row.get(this.columnIndexChecked(columnName));
        }

        public BinaryObject binaryObjectValue(int columnIndex) {
            return (BinaryObject)this.row.get(columnIndex);
        }

        public byte byteValue(@NotNull String columnName) {
            return (Byte)this.row.get(this.columnIndexChecked(columnName));
        }

        public byte byteValue(int columnIndex) {
            return (Byte)this.row.get(columnIndex);
        }

        public short shortValue(@NotNull String columnName) {
            return (Short)this.row.get(this.columnIndexChecked(columnName));
        }

        public short shortValue(int columnIndex) {
            return (Short)this.row.get(columnIndex);
        }

        public int intValue(@NotNull String columnName) {
            return (Integer)this.row.get(this.columnIndexChecked(columnName));
        }

        public int intValue(int columnIndex) {
            return (Integer)this.row.get(columnIndex);
        }

        public long longValue(@NotNull String columnName) {
            return (Long)this.row.get(this.columnIndexChecked(columnName));
        }

        public long longValue(int columnIndex) {
            return (Long)this.row.get(columnIndex);
        }

        public float floatValue(@NotNull String columnName) {
            return ((Float)this.row.get(this.columnIndexChecked(columnName))).floatValue();
        }

        public float floatValue(int columnIndex) {
            return ((Float)this.row.get(columnIndex)).floatValue();
        }

        public double doubleValue(@NotNull String columnName) {
            return (Double)this.row.get(this.columnIndexChecked(columnName));
        }

        public double doubleValue(int columnIndex) {
            return (Double)this.row.get(columnIndex);
        }

        public String stringValue(@NotNull String columnName) {
            return (String)this.row.get(this.columnIndexChecked(columnName));
        }

        public String stringValue(int columnIndex) {
            return (String)this.row.get(columnIndex);
        }

        public UUID uuidValue(@NotNull String columnName) {
            return (UUID)this.row.get(this.columnIndexChecked(columnName));
        }

        public UUID uuidValue(int columnIndex) {
            return (UUID)this.row.get(columnIndex);
        }

        public BitSet bitmaskValue(@NotNull String columnName) {
            return (BitSet)this.row.get(this.columnIndexChecked(columnName));
        }

        public BitSet bitmaskValue(int columnIndex) {
            return (BitSet)this.row.get(columnIndex);
        }

        public LocalDate dateValue(String columnName) {
            return (LocalDate)this.row.get(this.columnIndexChecked(columnName));
        }

        public LocalDate dateValue(int columnIndex) {
            return (LocalDate)this.row.get(columnIndex);
        }

        public LocalTime timeValue(String columnName) {
            return (LocalTime)this.row.get(this.columnIndexChecked(columnName));
        }

        public LocalTime timeValue(int columnIndex) {
            return (LocalTime)this.row.get(columnIndex);
        }

        public LocalDateTime datetimeValue(String columnName) {
            return (LocalDateTime)this.row.get(this.columnIndexChecked(columnName));
        }

        public LocalDateTime datetimeValue(int columnIndex) {
            return (LocalDateTime)this.row.get(columnIndex);
        }

        public Instant timestampValue(String columnName) {
            return (Instant)this.row.get(this.columnIndexChecked(columnName));
        }

        public Instant timestampValue(int columnIndex) {
            return (Instant)this.row.get(columnIndex);
        }

        public Iterator<Object> iterator() {
            return this.row.iterator();
        }

        public ResultSetMetadata metadata() {
            return this.meta;
        }
    }
}

