/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.ClusterTagBuilder;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class ClusterTagDeserializer
implements MessageDeserializer<ClusterTag> {
    private final ClusterTagBuilder msg;

    ClusterTagDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterTag();
    }

    public Class<ClusterTag> klass() {
        return ClusterTag.class;
    }

    public ClusterTag getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.clusterId(reader.readUuid("clusterId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.clusterName(reader.readString("clusterName"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterTag.class);
    }
}

