/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.criteria;

import java.util.Iterator;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;

public class CursorAdapter<T>
implements Cursor<T> {
    private final AsyncCursor<T> ac;
    private final Iterator<T> it;

    public CursorAdapter(AsyncCursor<T> ac) {
        assert (ac != null);
        this.ac = ac;
        this.it = new IteratorImpl<T>(ac);
    }

    @Override
    public void close() {
        try {
            this.ac.closeAsync().toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.unwrapCause(e));
        }
        catch (ExecutionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public T next() {
        return this.it.next();
    }

    private static class IteratorImpl<T>
    implements Iterator<T> {
        private AsyncCursor<T> curRes;
        private CompletionStage<? extends AsyncCursor<T>> nextPageStage;
        private Iterator<T> curPage;

        IteratorImpl(AsyncCursor<T> ars) {
            this.curRes = ars;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            if (this.curPage.hasNext()) {
                return true;
            }
            if (this.nextPageStage != null) {
                try {
                    this.curRes = this.nextPageStage.toCompletableFuture().join();
                }
                catch (CompletionException e) {
                    throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
                }
                this.advance();
                return this.curPage.hasNext();
            }
            return false;
        }

        private void advance() {
            this.curPage = this.curRes.currentPage().iterator();
            this.nextPageStage = this.curRes.hasMorePages() ? this.curRes.fetchNextPage() : null;
        }

        @Override
        public T next() {
            return this.curPage.next();
        }
    }
}

