/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshalling;

import java.io.Serializable;
import org.apache.ignite.marshalling.JavaSerializationByteArrayMarshalling;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.marshalling.UnsupportedObjectTypeMarshallingException;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public interface ByteArrayMarshaller<T>
extends Marshaller<T, byte[]> {
    public static <T> ByteArrayMarshaller<T> create() {
        return new ByteArrayMarshaller<T>(){};
    }

    @Override
    default public byte @Nullable [] marshal(@Nullable T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Serializable) {
            return JavaSerializationByteArrayMarshalling.marshal((Serializable)object);
        }
        throw new UnsupportedObjectTypeMarshallingException(object.getClass());
    }

    @Override
    @Nullable
    default public T unmarshal(byte @Nullable [] raw) {
        if (raw == null) {
            return null;
        }
        return JavaSerializationByteArrayMarshalling.unmarshal(raw);
    }
}

