/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster.metric;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.metric.MetricSourceEnableCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.ClusterMetricApi;
import org.apache.ignite.rest.client.invoker.ApiException;

@Singleton
public class ClusterMetricSourceEnableCall
implements Call<MetricSourceEnableCallInput, String> {
    private final ApiClientFactory clientFactory;

    public ClusterMetricSourceEnableCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<String> execute(MetricSourceEnableCallInput input) {
        ClusterMetricApi api = this.createApiClient(input);
        try {
            if (input.getEnable()) {
                api.enableClusterMetric(input.getSrcName());
            } else {
                api.disableClusterMetric(input.getSrcName());
            }
            String message = input.getEnable() ? "enabled" : "disabled";
            return DefaultCallOutput.success("Metric source was " + message + " successfully");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getEndpointUrl()));
        }
    }

    private ClusterMetricApi createApiClient(MetricSourceEnableCallInput input) {
        return new ClusterMetricApi(this.clientFactory.getClient(input.getEndpointUrl()));
    }
}

