/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.exporters.BasicMetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class PushMetricExporter<CfgT extends ExporterView>
extends BasicMetricExporter<CfgT> {
    protected final IgniteLogger log = Loggers.forClass(this.getClass());
    private ScheduledFuture<?> fut;
    private ScheduledExecutorService scheduler;
    private long period;

    @Override
    public synchronized void start(MetricProvider metricProvider, CfgT conf, Supplier<UUID> clusterIdSupplier, String nodeName) {
        super.start(metricProvider, conf, clusterIdSupplier, nodeName);
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("metrics-exporter-" + this.name(), this.log));
        this.reconfigure(conf);
    }

    @Override
    public synchronized void reconfigure(@Nullable CfgT newVal) {
        super.reconfigure(newVal);
        long newPeriod = this.period();
        if (this.period != newPeriod) {
            if (this.fut != null) {
                this.fut.cancel(false);
            }
            this.period = newPeriod;
            this.fut = this.scheduler.scheduleWithFixedDelay(() -> {
                try {
                    this.report();
                }
                catch (Throwable th) {
                    this.log.error("Metrics export error. This exporter will be stopped [class=" + String.valueOf(this.getClass()) + ",name=" + this.name() + "]", th);
                    throw th;
                }
            }, newPeriod, newPeriod, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.fut != null) {
            this.fut.cancel(false);
        }
        if (this.scheduler != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    protected abstract long period();

    public abstract void report();
}

