/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.rule.logical.ImmutableFilterScanMergeRule;
import org.apache.ignite.internal.sql.engine.rule.logical.RuleFactoryConfig;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.immutables.value.Value;

@Value.Enclosing
public abstract class FilterScanMergeRule<T extends ProjectableFilterableTableScan>
extends RelRule<Config> {
    public static final RelOptRule INDEX_SCAN = Config.INDEX_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN = Config.TABLE_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN_SKIP_CORRELATED = Config.TABLE_SCAN_SKIP_CORRELATED.toRule();
    public static final RelOptRule SYSTEM_VIEW_SCAN = Config.SYSTEM_VIEW_SCAN.toRule();
    public static final RelOptRule SYSTEM_VIEW_SCAN_SKIP_CORRELATED = Config.SYSTEM_VIEW_SCAN_SKIP_CORRELATED.toRule();

    private FilterScanMergeRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        final ProjectableFilterableTableScan scan = (ProjectableFilterableTableScan)call.rel(1);
        RelOptCluster cluster = scan.getCluster();
        RexBuilder builder = RexUtils.builder(cluster);
        RexNode condition = filter.getCondition();
        if (scan.projects() != null) {
            RexShuttle shuttle = new RexShuttle(){

                public RexNode visitInputRef(RexInputRef ref) {
                    return scan.projects().get(ref.getIndex());
                }
            };
            condition = shuttle.apply(condition);
        }
        if (scan.condition() != null) {
            condition = RexUtil.composeConjunction((RexBuilder)builder, Arrays.asList(scan.condition(), condition));
        }
        condition = RexUtils.replaceLocalRefs(condition);
        condition = new RexSimplify(builder, RelOptPredicateList.EMPTY, call.getPlanner().getExecutor()).simplifyUnknownAsFalse(condition);
        condition = RexUtils.replaceInputRefs(condition);
        RelTraitSet trait = cluster.traitSet();
        ProjectableFilterableTableScan res = this.createNode(cluster, scan, trait, condition);
        call.transformTo((RelNode)res);
    }

    protected abstract T createNode(RelOptCluster var1, T var2, RelTraitSet var3, RexNode var4);

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RuleFactoryConfig<Config> {
        public static final Config DEFAULT = ImmutableFilterScanMergeRule.Config.builder().withRuleFactory((Config x$0) -> new FilterTableScanMergeRule((Config)x$0)).build();
        public static final Config TABLE_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "FilterTableScanMergeRule", false);
        public static final Config TABLE_SCAN_SKIP_CORRELATED = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "FilterTableScanMergeSkipCorrelatedRule", true);
        public static final Config INDEX_SCAN = DEFAULT.withRuleFactory(x$0 -> new FilterIndexScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalIndexScan.class, "FilterIndexScanMergeRule", false);
        public static final Config SYSTEM_VIEW_SCAN = DEFAULT.withRuleFactory(x$0 -> new FilterSystemViewScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalSystemViewScan.class, "FilterSystemViewScanMergeRule", false);
        public static final Config SYSTEM_VIEW_SCAN_SKIP_CORRELATED = DEFAULT.withRuleFactory(x$0 -> new FilterSystemViewScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalSystemViewScan.class, "FilterSystemViewScanMergeSkipCorrelatedRule", true);

        default public Config withScanRuleConfig(Class<? extends ProjectableFilterableTableScan> scanCls, String desc, boolean skipCorrelated) {
            return (Config)this.withDescription(desc).withOperandSupplier(b -> b.operand(LogicalFilter.class).predicate(p -> !skipCorrelated || !RexUtils.hasCorrelation(p.getCondition())).oneInput(b1 -> b1.operand(scanCls).noInputs())).as(Config.class);
        }
    }

    private static class FilterSystemViewScanMergeRule
    extends FilterScanMergeRule<IgniteLogicalSystemViewScan> {
        private FilterSystemViewScanMergeRule(Config cfg) {
            super(cfg);
        }

        @Override
        protected IgniteLogicalSystemViewScan createNode(RelOptCluster cluster, IgniteLogicalSystemViewScan scan, RelTraitSet traits, RexNode cond) {
            return IgniteLogicalSystemViewScan.create(cluster, traits, (List<RelHint>)scan.getHints(), scan.getTable(), scan.projects(), cond, scan.requiredColumns());
        }
    }

    private static class FilterTableScanMergeRule
    extends FilterScanMergeRule<IgniteLogicalTableScan> {
        private FilterTableScanMergeRule(Config cfg) {
            super(cfg);
        }

        @Override
        protected IgniteLogicalTableScan createNode(RelOptCluster cluster, IgniteLogicalTableScan scan, RelTraitSet traits, RexNode cond) {
            return IgniteLogicalTableScan.create(cluster, traits, (List<RelHint>)scan.getHints(), scan.getTable(), scan.projects(), cond, scan.requiredColumns());
        }
    }

    private static class FilterIndexScanMergeRule
    extends FilterScanMergeRule<IgniteLogicalIndexScan> {
        private FilterIndexScanMergeRule(Config cfg) {
            super(cfg);
        }

        @Override
        protected IgniteLogicalIndexScan createNode(RelOptCluster cluster, IgniteLogicalIndexScan scan, RelTraitSet traits, RexNode cond) {
            return IgniteLogicalIndexScan.create(cluster, traits, scan.getTable(), scan.indexName(), scan.projects(), cond, scan.requiredColumns());
        }
    }
}

