/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.processor.AnnotationProcessor;
import io.micronaut.context.processor.BeanDefinitionProcessor;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationProcessorListener
implements BeanCreatedEventListener<AnnotationProcessor> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanContext.class);

    AnnotationProcessorListener() {
    }

    @Override
    public AnnotationProcessor onCreated(BeanCreatedEvent<AnnotationProcessor> event) {
        AnnotationProcessor processor = (AnnotationProcessor)event.getBean();
        BeanDefinition processorDefinition = event.getBeanDefinition();
        BeanContext beanContext = event.getSource();
        if (processor instanceof LifeCycle) {
            try {
                ((LifeCycle)((Object)processor)).start();
            }
            catch (Exception e) {
                throw new BeanContextException("Error starting bean processing: " + e.getMessage(), e);
            }
        }
        if (processor instanceof ExecutableMethodProcessor) {
            List<Argument<ExecutableMethodProcessor>> typeArguments = processorDefinition.getTypeArguments(ExecutableMethodProcessor.class);
            if (!typeArguments.isEmpty()) {
                Argument<ExecutableMethodProcessor> firstArgument = typeArguments.get(0);
                Collection<BeanDefinition<?>> beanDefinitions = beanContext.getBeanDefinitions(Qualifiers.byStereotype(firstArgument.getType()));
                boolean isParallel = firstArgument.isAnnotationPresent(Parallel.class);
                if (isParallel) {
                    for (BeanDefinition<?> beanDefinition : beanDefinitions) {
                        Collection<ExecutableMethod<?, ?>> executableMethods = beanDefinition.getExecutableMethods();
                        for (ExecutableMethod<?, ?> executableMethod : executableMethods) {
                            ForkJoinPool.commonPool().execute(() -> {
                                block4: {
                                    try {
                                        if (beanContext.isRunning()) {
                                            processor.process(beanDefinition, executableMethod);
                                        }
                                    }
                                    catch (Throwable e) {
                                        Boolean shutdownOnError;
                                        if (LOG.isErrorEnabled()) {
                                            LOG.error("Error processing bean method " + beanDefinition + "." + executableMethod + " with processor (" + processor + "): " + e.getMessage(), e);
                                        }
                                        if (!(shutdownOnError = executableMethod.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true)).booleanValue()) break block4;
                                        beanContext.stop();
                                    }
                                }
                            });
                        }
                    }
                } else {
                    for (BeanDefinition<?> beanDefinition : beanDefinitions) {
                        Collection<ExecutableMethod<?, ?>> executableMethods = beanDefinition.getExecutableMethods();
                        for (ExecutableMethod<?, ?> executableMethod : executableMethods) {
                            try {
                                processor.process(beanDefinition, executableMethod);
                            }
                            catch (Exception e) {
                                throw new BeanContextException("Error processing bean [" + beanDefinition + "] method definition [" + executableMethod + "]: " + e.getMessage(), e);
                            }
                        }
                    }
                }
            }
        } else if (processor instanceof BeanDefinitionProcessor) {
            BeanDefinitionProcessor beanDefinitionProcessor = (BeanDefinitionProcessor)processor;
            List<Argument<BeanDefinitionProcessor>> typeArguments = processorDefinition.getTypeArguments(BeanDefinitionProcessor.class);
            if (typeArguments.size() == 1) {
                Argument<BeanDefinitionProcessor> annotation = typeArguments.get(0);
                Collection<BeanDefinition<?>> beanDefinitions = beanContext.getBeanDefinitions(Qualifiers.byStereotype(annotation.getType()));
                for (BeanDefinition<?> beanDefinition : beanDefinitions) {
                    try {
                        beanDefinitionProcessor.process(beanDefinition, beanContext);
                    }
                    catch (Exception e) {
                        throw new BeanContextException("Error processing bean definition [" + beanDefinition + "]: " + e.getMessage(), e);
                    }
                }
            }
        }
        if (processor instanceof LifeCycle) {
            try {
                ((LifeCycle)((Object)processor)).stop();
            }
            catch (Exception e) {
                throw new BeanContextException("Error finalizing bean processing: " + e.getMessage(), e);
            }
        }
        return processor;
    }
}

