/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.index;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.table.distributed.index.TableRowToIndexKeyConverter;
import org.jetbrains.annotations.Nullable;

public class IndexUtils {
    public static void registerIndexToTable(TableViewInternal table, CatalogTableDescriptor tableDescriptor, CatalogIndexDescriptor indexDescriptor, PartitionSet partitionSet, SchemaRegistry schemaRegistry) {
        StorageIndexDescriptor storageIndexDescriptor = StorageIndexDescriptor.create((CatalogTableDescriptor)tableDescriptor, (CatalogIndexDescriptor)indexDescriptor);
        TableRowToIndexKeyConverter tableRowConverter = new TableRowToIndexKeyConverter(schemaRegistry, (String[])storageIndexDescriptor.columns().stream().map(StorageIndexDescriptor.StorageColumnDescriptor::name).toArray(String[]::new));
        if (storageIndexDescriptor instanceof StorageSortedIndexDescriptor) {
            table.registerSortedIndex((StorageSortedIndexDescriptor)storageIndexDescriptor, indexDescriptor.unique(), tableRowConverter, partitionSet);
        } else {
            table.registerHashIndex((StorageHashIndexDescriptor)storageIndexDescriptor, indexDescriptor.unique(), tableRowConverter, partitionSet);
        }
    }

    public static void registerIndexesToTable(TableViewInternal table, CatalogService catalogService, PartitionSet partitionSet, SchemaRegistry schemaRegistry, @Nullable HybridTimestamp lwm) {
        int earliestCatalogVersion = catalogService.activeCatalogVersion(HybridTimestamp.hybridTimestampToLong((HybridTimestamp)lwm));
        int latestCatalogVersion = catalogService.latestCatalogVersion();
        int tableId = table.tableId();
        IntOpenHashSet indexIds = new IntOpenHashSet();
        for (int catalogVersion = latestCatalogVersion; catalogVersion >= earliestCatalogVersion; --catalogVersion) {
            CatalogTableDescriptor tableDescriptor = catalogService.table(tableId, catalogVersion);
            if (tableDescriptor == null) continue;
            int ver0 = catalogVersion;
            catalogService.indexes(catalogVersion, tableId).stream().filter(idx -> ver0 == latestCatalogVersion || idx.status() == CatalogIndexStatus.AVAILABLE).filter(idx -> indexIds.add(idx.id())).forEach(idx -> IndexUtils.registerIndexToTable(table, tableDescriptor, idx, partitionSet, schemaRegistry));
        }
    }
}

