/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.internal.marshaller.MarshallerSchema;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.lang.ColumnNotFoundException;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

public class ClientSchema {
    private static final ClientColumn[] EMPTY_COLUMNS = new ClientColumn[0];
    private final int ver;
    private final ClientColumn[] columns;
    private final ClientColumn[] keyColumns;
    private final ClientColumn[] valColumns;
    private final ClientColumn[] colocationColumns;
    private final Map<String, ClientColumn> map = new HashMap<String, ClientColumn>();
    private final MarshallersProvider marshallers;
    private MarshallerSchema marshallerSchema;

    public ClientSchema(int ver, ClientColumn[] columns, MarshallersProvider marshallers) {
        assert (ver >= 0);
        assert (columns != null);
        this.ver = ver;
        this.columns = columns;
        this.marshallers = marshallers;
        int keyColumnCount = 0;
        int colocationColumnCount = 0;
        for (ClientColumn col : columns) {
            ClientColumn existing = this.map.put(col.name(), col);
            assert (existing == null) : "Duplicate column name: " + col.name();
            if (col.key()) {
                ++keyColumnCount;
            }
            if (col.colocationIndex() < 0) continue;
            ++colocationColumnCount;
        }
        int valColumnCount = columns.length - keyColumnCount;
        this.keyColumns = keyColumnCount == 0 ? EMPTY_COLUMNS : new ClientColumn[keyColumnCount];
        this.colocationColumns = colocationColumnCount == 0 ? this.keyColumns : new ClientColumn[colocationColumnCount];
        this.valColumns = valColumnCount == 0 ? EMPTY_COLUMNS : new ClientColumn[valColumnCount];
        for (ClientColumn col : columns) {
            if (col.key()) {
                assert (this.keyColumns[col.keyIndex()] == null) : "Duplicate key index: name=" + col.name() + ", keyIndex=" + col.keyIndex() + ", other.name=" + this.keyColumns[col.keyIndex()].name();
                this.keyColumns[col.keyIndex()] = col;
            } else {
                assert (this.valColumns[col.valIndex()] == null) : "Duplicate val index: name=" + col.name() + ", valIndex=" + col.valIndex() + ", other.name=" + this.valColumns[col.valIndex()].name();
                this.valColumns[col.valIndex()] = col;
            }
            if (col.colocationIndex() < 0) continue;
            assert (this.colocationColumns[col.colocationIndex()] == null) : "Duplicate colocation index: name=" + col.name() + ", colocationIndex=" + col.colocationIndex() + ", other.name=" + this.colocationColumns[col.colocationIndex()].name();
            this.colocationColumns[col.colocationIndex()] = col;
        }
        assert (Arrays.stream(this.keyColumns).allMatch(Objects::nonNull)) : "Some key columns are missing";
        assert (Arrays.stream(this.valColumns).allMatch(Objects::nonNull)) : "Some val columns are missing";
        assert (Arrays.stream(this.colocationColumns).allMatch(Objects::nonNull)) : "Some colocation columns are missing";
    }

    public int version() {
        return this.ver;
    }

    public ClientColumn[] columns() {
        return this.columns;
    }

    public ClientColumn[] columns(TuplePart part) {
        if (part == TuplePart.KEY) {
            return this.keyColumns;
        }
        if (part == TuplePart.VAL) {
            return this.valColumns;
        }
        return this.columns;
    }

    ClientColumn[] keyColumns() {
        return this.keyColumns;
    }

    ClientColumn[] valColumns() {
        return this.valColumns;
    }

    ClientColumn[] colocationColumns() {
        return this.colocationColumns;
    }

    public ClientColumn column(String name) {
        ClientColumn column = this.map.get(name);
        if (column == null) {
            throw new ColumnNotFoundException(name);
        }
        return column;
    }

    @Nullable
    public ClientColumn columnSafe(String name) {
        return this.map.get(name);
    }

    public <T> Marshaller getMarshaller(Mapper mapper, TuplePart part) {
        return this.getMarshaller(mapper, part, part == TuplePart.KEY);
    }

    public <T> Marshaller getMarshaller(Mapper mapper) {
        MarshallerColumn[] marshallerColumns = this.toMarshallerColumns(TuplePart.KEY_AND_VAL);
        return this.marshallers.getMarshaller(marshallerColumns, mapper, true, false);
    }

    <T> Marshaller getMarshaller(Mapper mapper, TuplePart part, boolean allowUnmappedFields) {
        switch (part) {
            case KEY: {
                return this.marshallers.getKeysMarshaller(this.marshallerSchema(), mapper, true, allowUnmappedFields);
            }
            case VAL: {
                return this.marshallers.getValuesMarshaller(this.marshallerSchema(), mapper, true, allowUnmappedFields);
            }
            case KEY_AND_VAL: {
                return this.marshallers.getRowMarshaller(this.marshallerSchema(), mapper, true, allowUnmappedFields);
            }
        }
        throw new AssertionError((Object)("Unexpected tuple part: " + String.valueOf(part)));
    }

    private MarshallerColumn[] toMarshallerColumns(TuplePart part) {
        if (part == TuplePart.VAL) {
            MarshallerColumn[] res = new MarshallerColumn[this.columns.length - this.keyColumns.length];
            int idx = 0;
            for (ClientColumn col : this.columns) {
                if (col.key()) continue;
                res[idx++] = ClientSchema.marshallerColumn(col);
            }
            return res;
        }
        ClientColumn[] cols = part == TuplePart.KEY_AND_VAL ? this.columns : this.keyColumns;
        MarshallerColumn[] res = new MarshallerColumn[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            res[i] = ClientSchema.marshallerColumn(cols[i]);
        }
        return res;
    }

    private static MarshallerColumn marshallerColumn(ClientColumn col) {
        return new MarshallerColumn(col.schemaIndex(), col.name(), ClientSchema.mode(col.type()), null, col.scale());
    }

    private static BinaryMode mode(ColumnType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return BinaryMode.BOOLEAN;
            }
            case INT8: {
                return BinaryMode.BYTE;
            }
            case INT16: {
                return BinaryMode.SHORT;
            }
            case INT32: {
                return BinaryMode.INT;
            }
            case INT64: {
                return BinaryMode.LONG;
            }
            case FLOAT: {
                return BinaryMode.FLOAT;
            }
            case DOUBLE: {
                return BinaryMode.DOUBLE;
            }
            case UUID: {
                return BinaryMode.UUID;
            }
            case STRING: {
                return BinaryMode.STRING;
            }
            case BYTE_ARRAY: {
                return BinaryMode.BYTE_ARR;
            }
            case DECIMAL: {
                return BinaryMode.DECIMAL;
            }
            case DATE: {
                return BinaryMode.DATE;
            }
            case TIME: {
                return BinaryMode.TIME;
            }
            case DATETIME: {
                return BinaryMode.DATETIME;
            }
            case TIMESTAMP: {
                return BinaryMode.TIMESTAMP;
            }
        }
        throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unknown client data type: " + String.valueOf(dataType));
    }

    private MarshallerSchema marshallerSchema() {
        if (this.marshallerSchema == null) {
            this.marshallerSchema = new ClientMarshallerSchema(this);
        }
        return this.marshallerSchema;
    }

    private static class ClientMarshallerSchema
    implements MarshallerSchema {
        private final ClientSchema schema;
        private MarshallerColumn[] keys;
        private MarshallerColumn[] values;
        private MarshallerColumn[] row;

        private ClientMarshallerSchema(ClientSchema schema) {
            this.schema = schema;
        }

        public int schemaVersion() {
            return this.schema.version();
        }

        public MarshallerColumn[] keys() {
            if (this.keys == null) {
                this.keys = this.schema.toMarshallerColumns(TuplePart.KEY);
            }
            return this.keys;
        }

        public MarshallerColumn[] values() {
            if (this.values == null) {
                this.values = this.schema.toMarshallerColumns(TuplePart.VAL);
            }
            return this.values;
        }

        public MarshallerColumn[] row() {
            if (this.row == null) {
                this.row = this.schema.toMarshallerColumns(TuplePart.KEY_AND_VAL);
            }
            return this.row;
        }
    }
}

