/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.CreateTableCommandBuilder;
import org.apache.ignite.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite.internal.catalog.storage.NewTableEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class CreateTableCommand
extends AbstractTableCommand {
    private final TablePrimaryKey primaryKey;
    private final List<String> colocationColumns;
    private final List<ColumnParams> columns;
    private final String zoneName;
    private String storageProfile;

    public static CreateTableCommandBuilder builder() {
        return new Builder();
    }

    private CreateTableCommand(String tableName, String schemaName, boolean ifNotExists, TablePrimaryKey primaryKey, List<String> colocationColumns, List<ColumnParams> columns, @Nullable String zoneName, String storageProfile) throws CatalogValidationException {
        super(schemaName, tableName, ifNotExists);
        this.primaryKey = primaryKey;
        this.colocationColumns = CollectionUtils.copyOrNull(colocationColumns);
        this.columns = CollectionUtils.copyOrNull(columns);
        this.zoneName = zoneName;
        this.storageProfile = storageProfile;
        this.validate();
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogZoneDescriptor zone;
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.tableName);
        if (this.zoneName == null) {
            if (catalog.defaultZone() == null) {
                throw new CatalogValidationException("The zone is not specified. Please specify zone explicitly or set default one.");
            }
            zone = catalog.defaultZone();
        } else {
            zone = CatalogUtils.zoneOrThrow(catalog, this.zoneName);
        }
        if (this.storageProfile == null) {
            this.storageProfile = zone.storageProfiles().defaultProfile().storageProfile();
        }
        CatalogParamsValidationUtils.ensureZoneContainsTablesStorageProfile(zone, this.storageProfile);
        int id = catalog.objectIdGenState();
        int tableId = id++;
        int pkIndexId = id++;
        CatalogTableDescriptor table = new CatalogTableDescriptor(tableId, schema.id(), pkIndexId, this.tableName, zone.id(), this.columns.stream().map(CatalogUtils::fromParams).collect(Collectors.toList()), this.primaryKey.columns(), this.colocationColumns, this.storageProfile);
        String indexName = CatalogUtils.pkIndexName(this.tableName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        CatalogIndexDescriptor pkIndex = this.createPkIndexDescriptor(indexName, pkIndexId, tableId);
        return List.of(new NewTableEntry(table), new NewIndexEntry(pkIndex), new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState()));
    }

    private void validate() {
        if (CollectionUtils.nullOrEmpty(this.columns)) {
            throw new CatalogValidationException("Table should have at least one column.");
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnParams column : this.columns) {
            if (columnNames.add(column.name())) continue;
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column with name '{}' specified more than once.", (Object[])new Object[]{column.name()}));
        }
        if (this.primaryKey == null || CollectionUtils.nullOrEmpty(this.primaryKey.columns())) {
            throw new CatalogValidationException("Table should have primary key.");
        }
        this.primaryKey.validate(this.columns);
        for (ColumnParams column : this.columns) {
            boolean partOfPk = this.primaryKey.columns().contains(column.name());
            CatalogUtils.ensureTypeCanBeStored(column.name(), column.type());
            if (partOfPk) {
                CatalogUtils.ensureSupportedDefault(column.name(), column.type(), column.defaultValueDefinition());
                continue;
            }
            CatalogUtils.ensureNonFunctionalDefault(column.name(), column.defaultValueDefinition());
        }
        if (CollectionUtils.nullOrEmpty(this.colocationColumns)) {
            throw new CatalogValidationException("Colocation columns could not be empty.");
        }
        HashSet<String> colocationColumnsSet = new HashSet<String>();
        for (String name : this.colocationColumns) {
            if (!this.primaryKey.columns().contains(name)) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Colocation column '{}' is not part of PK.", (Object[])new Object[]{name}));
            }
            if (colocationColumnsSet.add(name)) continue;
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Colocation column '{}' specified more that once", (Object[])new Object[]{name}));
        }
    }

    private CatalogIndexDescriptor createPkIndexDescriptor(String indexName, int pkIndexId, int tableId) {
        CatalogIndexDescriptor pkIndex;
        if (this.primaryKey instanceof TableSortedPrimaryKey) {
            TableSortedPrimaryKey sortedPrimaryKey = (TableSortedPrimaryKey)this.primaryKey;
            ArrayList<CatalogIndexColumnDescriptor> indexColumns = new ArrayList<CatalogIndexColumnDescriptor>(sortedPrimaryKey.columns().size());
            for (int i = 0; i < sortedPrimaryKey.columns().size(); ++i) {
                String columnName = sortedPrimaryKey.columns().get(i);
                CatalogColumnCollation collation = sortedPrimaryKey.collations().get(i);
                indexColumns.add(new CatalogIndexColumnDescriptor(columnName, collation));
            }
            pkIndex = new CatalogSortedIndexDescriptor(pkIndexId, indexName, tableId, true, CatalogIndexStatus.AVAILABLE, indexColumns, true);
        } else if (this.primaryKey instanceof TableHashPrimaryKey) {
            TableHashPrimaryKey hashPrimaryKey = (TableHashPrimaryKey)this.primaryKey;
            pkIndex = new CatalogHashIndexDescriptor(pkIndexId, indexName, tableId, true, CatalogIndexStatus.AVAILABLE, hashPrimaryKey.columns(), true);
        } else {
            throw new IllegalArgumentException("Unexpected primary key type: " + String.valueOf(this.primaryKey));
        }
        return pkIndex;
    }

    private static class Builder
    implements CreateTableCommandBuilder {
        private List<ColumnParams> columns;
        private String schemaName;
        private String tableName;
        private boolean ifNotExists;
        private TablePrimaryKey primaryKey;
        private List<String> colocationColumns;
        private String zoneName;
        private String storageProfile;

        private Builder() {
        }

        @Override
        public CreateTableCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder ifTableExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateTableCommandBuilder columns(List<ColumnParams> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CreateTableCommandBuilder primaryKey(TablePrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public CreateTableCommandBuilder colocationColumns(List<String> colocationColumns) {
            this.colocationColumns = colocationColumns;
            return this;
        }

        @Override
        public CreateTableCommandBuilder zone(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder storageProfile(String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        @Override
        public CatalogCommand build() {
            List<String> colocationColumns = this.colocationColumns != null ? this.colocationColumns : (this.primaryKey != null ? this.primaryKey.columns() : null);
            return new CreateTableCommand(this.tableName, this.schemaName, this.ifNotExists, this.primaryKey, colocationColumns, this.columns, this.zoneName, this.storageProfile);
        }
    }
}

