/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class CatalogSortedIndexDescriptor
extends CatalogIndexDescriptor {
    public static final CatalogObjectSerializer<CatalogSortedIndexDescriptor> SERIALIZER = new SortedIndexDescriptorSerializer();
    private final List<CatalogIndexColumnDescriptor> columns;

    public CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, List<CatalogIndexColumnDescriptor> columns) {
        this(id, name, tableId, unique, CatalogIndexStatus.REGISTERED, columns, false);
    }

    public CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<CatalogIndexColumnDescriptor> columns, boolean isCreatedWithTable) {
        this(id, name, tableId, unique, status, columns, 0L, isCreatedWithTable);
    }

    private CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<CatalogIndexColumnDescriptor> columns, long causalityToken, boolean isCreatedWithTable) {
        super(CatalogIndexDescriptor.CatalogIndexDescriptorType.SORTED, id, name, tableId, unique, status, causalityToken, isCreatedWithTable);
        this.columns = Objects.requireNonNull(columns, "columns");
    }

    public List<CatalogIndexColumnDescriptor> columns() {
        return this.columns;
    }

    @Override
    public String toString() {
        return S.toString(CatalogSortedIndexDescriptor.class, (Object)this, (String)super.toString());
    }

    private static class SortedIndexDescriptorSerializer
    implements CatalogObjectSerializer<CatalogSortedIndexDescriptor> {
        private SortedIndexDescriptorSerializer() {
        }

        @Override
        public CatalogSortedIndexDescriptor readFrom(IgniteDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateToken = input.readVarInt();
            int tableId = input.readVarIntAsInt();
            boolean unique = input.readBoolean();
            CatalogIndexStatus status = CatalogIndexStatus.forId(input.readByte());
            boolean isCreatedWithTable = input.readBoolean();
            List<CatalogIndexColumnDescriptor> columns = CatalogSerializationUtils.readList(CatalogIndexColumnDescriptor.SERIALIZER, input);
            return new CatalogSortedIndexDescriptor(id, name, tableId, unique, status, columns, updateToken, isCreatedWithTable);
        }

        @Override
        public void writeTo(CatalogSortedIndexDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateToken());
            output.writeVarInt((long)descriptor.tableId());
            output.writeBoolean(descriptor.unique());
            output.writeByte(descriptor.status().id());
            output.writeBoolean(descriptor.isCreatedWithTable());
            CatalogSerializationUtils.writeList(descriptor.columns(), CatalogIndexColumnDescriptor.SERIALIZER, output);
        }
    }
}

