/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateSystemViewEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class NewSystemViewEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<NewSystemViewEntry> SERIALIZER = new NewSystemViewEntrySerializer();
    private final CatalogSystemViewDescriptor descriptor;

    public NewSystemViewEntry(CatalogSystemViewDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_SYS_VIEW.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SYSTEM_VIEW_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CreateSystemViewEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, this.descriptor.schemaId());
        this.descriptor.updateToken(causalityToken);
        Map systemViews = Arrays.stream(systemSchema.systemViews()).collect(Collectors.toMap(CatalogObjectDescriptor::name, Function.identity()));
        systemViews.put(this.descriptor.name(), this.descriptor);
        CatalogSystemViewDescriptor[] sysViewArray = systemViews.values().toArray(new CatalogSystemViewDescriptor[0]);
        CatalogSchemaDescriptor newSystemSchema = new CatalogSchemaDescriptor(systemSchema.id(), systemSchema.name(), systemSchema.tables(), systemSchema.indexes(), sysViewArray, causalityToken);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(newSystemSchema, catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class NewSystemViewEntrySerializer
    implements CatalogObjectSerializer<NewSystemViewEntry> {
        private NewSystemViewEntrySerializer() {
        }

        @Override
        public NewSystemViewEntry readFrom(IgniteDataInput input) throws IOException {
            CatalogSystemViewDescriptor descriptor = CatalogSystemViewDescriptor.SERIALIZER.readFrom(input);
            return new NewSystemViewEntry(descriptor);
        }

        @Override
        public void writeTo(NewSystemViewEntry entry, IgniteDataOutput output) throws IOException {
            CatalogSystemViewDescriptor.SERIALIZER.writeTo(entry.descriptor, output);
        }
    }
}

