/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.failure;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.failure.NodeStopper;
import org.apache.ignite.internal.failure.configuration.FailureProcessorConfiguration;
import org.apache.ignite.internal.failure.handlers.AbstractFailureHandler;
import org.apache.ignite.internal.failure.handlers.FailureHandler;
import org.apache.ignite.internal.failure.handlers.NoOpFailureHandler;
import org.apache.ignite.internal.failure.handlers.StopNodeFailureHandler;
import org.apache.ignite.internal.failure.handlers.StopNodeOrHaltFailureHandler;
import org.apache.ignite.internal.failure.handlers.configuration.FailureHandlerView;
import org.apache.ignite.internal.failure.handlers.configuration.StopNodeOrHaltFailureHandlerView;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.thread.ThreadUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class FailureManager
implements FailureProcessor,
IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(FailureManager.class);
    private static final String FAILURE_LOG_MSG = "Critical system error detected. Will be handled accordingly to configured handler [hnd={}, failureCtx={}]";
    private static final String IGNORED_FAILURE_LOG_MSG = "Possible failure suppressed according to a configured handler [hnd={}, failureCtx={}]";
    private final FailureProcessorConfiguration configuration;
    private volatile FailureHandler handler;
    private final NodeStopper nodeStopper;
    @Nullable
    private FailureHandler interceptor;
    private volatile FailureContext failureCtx;
    private volatile byte @Nullable [] reserveBuf;
    private volatile boolean dumpThreadsOnFailure;
    private volatile long dumpThreadsThrottlingTimeout;
    @Nullable
    private volatile Map<FailureType, Long> threadDumpPerFailureTypeTs;

    public FailureManager(FailureHandler handler) {
        this.nodeStopper = () -> {};
        this.handler = handler;
        this.configuration = null;
    }

    public FailureManager(NodeStopper nodeStopper, FailureProcessorConfiguration configuration) {
        this.nodeStopper = nodeStopper;
        this.configuration = configuration;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.initFailureHandler();
        LOG.info("Configured failure handler: [hnd={}]", new Object[]{this.handler});
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    public FailureContext failureContext() {
        return this.failureCtx;
    }

    public boolean process(FailureContext failureCtx) {
        return this.process(failureCtx, this.handler);
    }

    private synchronized boolean process(FailureContext failureCtx, FailureHandler handler) {
        boolean invalidated;
        assert (failureCtx != null) : "Failure context is not initialized.";
        assert (handler != null) : "Failure handler is not initialized.";
        if (this.interceptor != null) {
            this.interceptor.onFailure(failureCtx);
        }
        if (this.failureCtx != null) {
            return false;
        }
        if (handler.ignoredFailureTypes().contains(failureCtx.type())) {
            LOG.warn(IGNORED_FAILURE_LOG_MSG, failureCtx.error(), new Object[]{handler, failureCtx.type()});
        } else {
            LOG.error(FAILURE_LOG_MSG, failureCtx.error(), new Object[]{handler, failureCtx.type()});
        }
        if (this.reserveBuf != null && ExceptionUtils.hasCauseOrSuppressed((Throwable)failureCtx.error(), (Class[])new Class[]{OutOfMemoryError.class})) {
            this.reserveBuf = null;
        }
        if (this.dumpThreadsOnFailure && !this.throttleThreadDump(failureCtx.type())) {
            ThreadUtils.dumpThreads((IgniteLogger)LOG, (!handler.ignoredFailureTypes().contains(failureCtx.type()) ? 1 : 0) != 0);
        }
        if (invalidated = handler.onFailure(failureCtx)) {
            this.failureCtx = failureCtx;
            LOG.error("Ignite node is in invalid state due to a critical failure.", new Object[0]);
        }
        return invalidated;
    }

    private void initFailureHandler() {
        AbstractFailureHandler hnd;
        if (this.configuration == null) {
            assert (this.handler != null) : "Failure handler is not initialized.";
            return;
        }
        this.dumpThreadsOnFailure = (Boolean)this.configuration.dumpThreadsOnFailure().value();
        this.dumpThreadsThrottlingTimeout = (Long)this.configuration.dumpThreadsThrottlingTimeoutMillis().value();
        this.threadDumpPerFailureTypeTs = null;
        if (this.dumpThreadsOnFailure && this.dumpThreadsThrottlingTimeout > 0L) {
            EnumMap<FailureType, Long> dumpPerFailureTypeTs = new EnumMap<FailureType, Long>(FailureType.class);
            for (FailureType type : FailureType.values()) {
                dumpPerFailureTypeTs.put(type, 0L);
            }
            this.threadDumpPerFailureTypeTs = dumpPerFailureTypeTs;
        }
        this.reserveBuf = new byte[((Integer)this.configuration.oomBufferSizeBites().value()).intValue()];
        FailureHandlerView handlerView = (FailureHandlerView)this.configuration.handler().value();
        switch (handlerView.type()) {
            case "noop": {
                hnd = new NoOpFailureHandler();
                break;
            }
            case "stop": {
                hnd = new StopNodeFailureHandler(this.nodeStopper);
                break;
            }
            case "stopOrHalt": {
                hnd = new StopNodeOrHaltFailureHandler(this.nodeStopper, (StopNodeOrHaltFailureHandlerView)handlerView);
                break;
            }
            default: {
                throw new IgniteException(ErrorGroups.Common.COMPONENT_NOT_STARTED_ERR, "Unknown failure handler type: " + handlerView.type());
            }
        }
        String[] ignoredFailureTypes = handlerView.ignoredFailureTypes();
        EnumSet<FailureType> ignoredFailureTypesSet = EnumSet.noneOf(FailureType.class);
        for (String ignoredFailureType : ignoredFailureTypes) {
            for (FailureType type : FailureType.values()) {
                if (!type.typeName().equals(ignoredFailureType)) continue;
                ignoredFailureTypesSet.add(type);
            }
        }
        hnd.ignoredFailureTypes(ignoredFailureTypesSet);
        this.handler = hnd;
    }

    @TestOnly
    public synchronized void setInterceptor(@Nullable FailureHandler interceptor) {
        this.interceptor = interceptor;
    }

    FailureHandler handler() {
        return this.handler;
    }

    private boolean throttleThreadDump(FailureType type) {
        boolean throttle;
        Map<FailureType, Long> dumpPerFailureTypeTs = this.threadDumpPerFailureTypeTs;
        long dumpThrottlingTimeout = this.dumpThreadsThrottlingTimeout;
        if (dumpThrottlingTimeout == 0L || dumpPerFailureTypeTs == null) {
            return false;
        }
        long curr = System.currentTimeMillis();
        Long last = dumpPerFailureTypeTs.get(type);
        assert (last != null) : "Unknown failure type " + String.valueOf(type);
        boolean bl = throttle = curr - last < dumpThrottlingTimeout;
        if (!throttle) {
            dumpPerFailureTypeTs.put(type, curr);
        } else {
            LOG.info("Thread dump is hidden due to throttling settings. Set 'dumpThreadsThrottlingTimeoutMillis' property to 0 to see all thread dumps.", new Object[0]);
        }
        return throttle;
    }
}

