/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.util;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.raft.Marshaller;
import org.apache.ignite.internal.raft.util.DefaultByteBuffersPool;
import org.apache.ignite.internal.raft.util.OptimizedMarshaller;

public class ThreadLocalOptimizedMarshaller
implements Marshaller {
    private final ThreadLocal<Marshaller> marshaller;
    private final OptimizedMarshaller.ByteBuffersPool pool = new DefaultByteBuffersPool(Runtime.getRuntime().availableProcessors());

    public ThreadLocalOptimizedMarshaller(MessageSerializationRegistry serializationRegistry) {
        this.marshaller = ThreadLocal.withInitial(() -> new OptimizedMarshaller(serializationRegistry, this.pool));
    }

    public byte[] marshall(Object o) {
        return this.marshaller.get().marshall(o);
    }

    public <T> T unmarshall(ByteBuffer bytes) {
        return (T)this.marshaller.get().unmarshall(bytes);
    }
}

