/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorsState;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateRow;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class SortAggregateNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final AggregateType type;
    private final RowHandler.RowFactory<RowT> rowFactory;
    private final ImmutableBitSet grpSet;
    private final Comparator<RowT> comp;
    private final Deque<RowT> outBuf = new ArrayDeque<RowT>(512);
    private final List<AccumulatorWrapper<RowT>> accs;
    private RowT prevRow;
    private Group grp;
    private int requested;
    private int waiting;
    private int cmpRes;

    public SortAggregateNode(ExecutionContext<RowT> ctx, AggregateType type, ImmutableBitSet grpSet, List<AccumulatorWrapper<RowT>> accumulators, RowHandler.RowFactory<RowT> rowFactory, Comparator<RowT> comp) {
        super(ctx);
        assert (Objects.nonNull(comp));
        this.type = type;
        this.rowFactory = rowFactory;
        this.grpSet = grpSet;
        this.comp = comp;
        this.accs = accumulators;
        this.init();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.outBuf.isEmpty()) {
            this.doPush();
        }
        if (this.waiting == 0) {
            this.waiting = 512;
            this.source().request(512);
        } else if (this.waiting < 0 && this.requested > 0) {
            this.downstream().end();
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        if (this.grp != null) {
            int cmp = this.comp.compare(row, this.prevRow);
            if (cmp == 0) {
                this.grp.add(row);
            } else {
                if (this.cmpRes == 0) {
                    this.cmpRes = cmp;
                } else assert (Integer.signum(cmp) == Integer.signum(this.cmpRes)) : "Input not sorted";
                this.outBuf.add(this.grp.row());
                this.grp = this.newGroup(row);
                this.doPush();
            }
        } else {
            this.grp = this.newGroup(row);
        }
        this.prevRow = row;
        if (this.waiting == 0 && this.requested > 0) {
            this.waiting = 512;
            this.context().execute(() -> this.source().request(512), this::onError);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        if (this.grp != null) {
            this.outBuf.add(this.grp.row());
            this.doPush();
        }
        if (this.requested > 0) {
            this.downstream().end();
        }
        this.grp = null;
        this.prevRow = null;
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.grp = null;
        this.prevRow = null;
        this.init();
    }

    private void init() {
        if (AggregateRow.addEmptyGroup(this.grpSet, this.type)) {
            this.grp = new Group(ArrayUtils.OBJECT_EMPTY_ARRAY);
        }
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private Group newGroup(RowT r) {
        Object[] grpKeys = new Object[this.grpSet.cardinality()];
        List fldIdxs = this.grpSet.asList();
        RowHandler<RowT> rowHandler = this.rowFactory.handler();
        for (int i = 0; i < grpKeys.length; ++i) {
            grpKeys[i] = rowHandler.get((Integer)fldIdxs.get(i), r);
        }
        Group grp = new Group(grpKeys);
        grp.add(r);
        return grp;
    }

    private void doPush() throws Exception {
        while (this.requested > 0 && !this.outBuf.isEmpty()) {
            --this.requested;
            this.downstream().push(this.outBuf.poll());
        }
    }

    private class Group {
        private final Object[] grpKeys;
        private final AggregateRow<RowT> aggRow;

        private Group(Object[] grpKeys) {
            this.grpKeys = grpKeys;
            AccumulatorsState state = new AccumulatorsState(SortAggregateNode.this.accs.size());
            Int2ObjectArrayMap distinctSets = new Int2ObjectArrayMap();
            for (int i = 0; i < SortAggregateNode.this.accs.size(); ++i) {
                AccumulatorWrapper acc = SortAggregateNode.this.accs.get(i);
                if (!acc.isDistinct()) continue;
                distinctSets.put(i, new HashSet());
            }
            this.aggRow = new AggregateRow(state, (Int2ObjectArrayMap<Set<Object>>)distinctSets);
        }

        private void add(RowT row) {
            this.aggRow.update(SortAggregateNode.this.accs, SortAggregateNode.this.grpSet, SortAggregateNode.this.context().rowHandler(), row);
        }

        private RowT row() {
            Object[] fields = this.aggRow.createOutput(SortAggregateNode.this.type, SortAggregateNode.this.accs, SortAggregateNode.this.grpSet, (byte)-1);
            int i = 0;
            for (Object grpKey : this.grpKeys) {
                fields[i++] = grpKey;
            }
            this.aggRow.writeTo(SortAggregateNode.this.type, SortAggregateNode.this.accs, fields, SortAggregateNode.this.grpSet, (byte)-1);
            return SortAggregateNode.this.rowFactory.create(fields);
        }
    }
}

