/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;

public class IgniteReceiver
extends AbstractRelNode
implements IgniteRel {
    private static final String REL_TYPE_NAME = "Receiver";
    private final long exchangeId;
    private final long sourceFragmentId;
    private final RelCollation collation;

    public IgniteReceiver(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, long exchangeId, long sourceFragmentId) {
        this(cluster, traits, rowType, exchangeId, sourceFragmentId, traits.getCollation());
    }

    public IgniteReceiver(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), input.getRowType("rowType"), ((Number)input.get("exchangeId")).longValue(), ((Number)input.get("sourceFragmentId")).longValue(), input.getCollation());
    }

    private IgniteReceiver(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, long exchangeId, long sourceFragmentId, RelCollation collation) {
        super(cluster, traits);
        this.exchangeId = exchangeId;
        this.sourceFragmentId = sourceFragmentId;
        this.rowType = rowType;
        this.collation = collation;
    }

    public long exchangeId() {
        return this.exchangeId;
    }

    public long sourceFragmentId() {
        return this.sourceFragmentId;
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IgniteReceiver(this.getCluster(), traitSet, this.rowType, this.exchangeId, this.sourceFragmentId, this.collation);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        RelWriter writer = super.explainTerms(pw);
        if (pw.getDetailLevel() != SqlExplainLevel.ALL_ATTRIBUTES) {
            return writer;
        }
        return writer.item("rowType", (Object)this.rowType).item("exchangeId", (Object)this.exchangeId).item("sourceFragmentId", (Object)this.sourceFragmentId).itemIf("collation", (Object)this.collation, this.collation != null && this.collation != RelCollations.EMPTY);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        throw new RuntimeException(this.getClass().getName() + "#passThroughTraits() is not implemented.");
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        throw new RuntimeException(this.getClass().getName() + "#deriveTraits() is not implemented.");
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteReceiver(cluster, this.getTraitSet(), this.rowType, this.exchangeId, this.sourceFragmentId, this.collation);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

