/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.util.AbstractProjectedTuple;

public class FormatAwareProjectedTuple
extends AbstractProjectedTuple {
    public FormatAwareProjectedTuple(InternalTuple delegate, int[] projection) {
        super(delegate, projection);
    }

    @Override
    protected void normalize() {
        int[] newProjection = new int[this.projection.length];
        ByteBuffer tupleBuffer = this.delegate.byteBuffer();
        BinaryTupleParser parser = new BinaryTupleParser(this.delegate.elementCount(), tupleBuffer);
        var stats = new BinaryTupleParser.Sink(){
            int estimatedValueSize = 0;

            public void nextElement(int index, int begin, int end) {
                this.estimatedValueSize += end - begin;
            }
        };
        for (int columnIndex : this.projection) {
            parser.fetch(columnIndex, stats);
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(this.projection.length, stats.estimatedValueSize);
        for (int i = 0; i < this.projection.length; ++i) {
            int columnIndex = this.projection[i];
            parser.fetch(columnIndex, (index, begin, end) -> {
                if (begin == end) {
                    builder.appendNull();
                } else {
                    builder.appendElementBytes(tupleBuffer, begin, end - begin);
                }
            });
            newProjection[i] = columnIndex;
        }
        this.delegate = new BinaryTuple(this.projection.length, builder.build());
        this.projection = newProjection;
    }
}

