/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;

public class DateTimeStringUtils {
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String ISO_DATETIME_FRACTIONAL_SECOND_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private DateTimeStringUtils() {
    }

    static String pad(int length, long v) {
        StringBuilder s = new StringBuilder(Long.toString(v));
        while (s.length() < length) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    static StringBuilder hms(StringBuilder b, int h, int m, int s) {
        DateTimeStringUtils.int2(b, h);
        b.append(':');
        DateTimeStringUtils.int2(b, m);
        b.append(':');
        DateTimeStringUtils.int2(b, s);
        return b;
    }

    static StringBuilder ymdhms(StringBuilder b, int year, int month, int day, int h, int m, int s) {
        DateTimeStringUtils.ymd(b, year, month, day);
        b.append(' ');
        DateTimeStringUtils.hms(b, h, m, s);
        return b;
    }

    static StringBuilder ymd(StringBuilder b, int year, int month, int day) {
        DateTimeStringUtils.int4(b, year);
        b.append('-');
        DateTimeStringUtils.int2(b, month);
        b.append('-');
        DateTimeStringUtils.int2(b, day);
        return b;
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    static boolean isValidTimeZone(String timeZone) {
        if (timeZone.equals("GMT")) {
            return true;
        }
        String id = TimeZone.getTimeZone(timeZone).getID();
        return !id.equals("GMT");
    }

    public static SimpleDateFormat getDateFormatter(String format) {
        return DateTimeStringUtils.getDateFormatter(format, DateTimeUtils.UTC_ZONE);
    }

    public static SimpleDateFormat getDateFormatter(String format, TimeZone timeZone) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(format, Locale.ROOT);
        dateFormatter.setTimeZone(timeZone);
        return dateFormatter;
    }
}

