/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.RolesFinder;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class AbstractSecurityRule
implements SecurityRule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSecurityRule.class);
    private final RolesFinder rolesFinder;

    @Inject
    public AbstractSecurityRule(RolesFinder rolesFinder) {
        this.rolesFinder = rolesFinder;
    }

    protected List<String> getRoles(Authentication authentication) {
        ArrayList<String> roles = new ArrayList<String>();
        if (authentication == null) {
            roles.add("isAnonymous()");
        } else {
            roles.addAll(authentication.getRoles());
            roles.add("isAnonymous()");
            roles.add("isAuthenticated()");
        }
        return roles;
    }

    protected Publisher<SecurityRuleResult> compareRoles(List<String> requiredRoles, Collection<String> grantedRoles) {
        if (this.rolesFinder.hasAnyRequiredRoles(requiredRoles, grantedRoles)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The given roles [{}] matched one or more of the required roles [{}]. Allowing the request", grantedRoles, requiredRoles);
            }
            return Mono.just((Object)((Object)SecurityRuleResult.ALLOWED));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("None of the given roles [{}] matched the required roles [{}]. Rejecting the request", grantedRoles, requiredRoles);
        }
        return Mono.just((Object)((Object)SecurityRuleResult.REJECTED));
    }
}

