/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.table.distributed.DroppedTableInfo;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class TableUtils {
    public static List<Integer> indexIdsAtRwTxBeginTs(CatalogService catalogService, UUID txId, int tableId) {
        HybridTimestamp beginTs = TransactionIds.beginTimestamp((UUID)txId);
        int catalogVersion = catalogService.activeCatalogVersion(beginTs.longValue());
        List indexes = catalogService.indexes(catalogVersion, tableId);
        assert (!indexes.isEmpty()) : String.format("txId=%s, tableId=%s, catalogVersion=%s", txId, tableId, catalogVersion);
        return CollectionUtils.view((List)indexes, CatalogObjectDescriptor::id);
    }

    static List<DroppedTableInfo> droppedTables(CatalogService catalogService, @Nullable HybridTimestamp lowWatermark) {
        if (lowWatermark == null) {
            return List.of();
        }
        int earliestCatalogVersion = catalogService.earliestCatalogVersion();
        int lwmCatalogVersion = catalogService.activeCatalogVersion(lowWatermark.longValue());
        Set tableIds = catalogService.tables(lwmCatalogVersion).stream().map(CatalogObjectDescriptor::id).collect(Collectors.toCollection(HashSet::new));
        ArrayList<DroppedTableInfo> res = new ArrayList<DroppedTableInfo>();
        for (int catalogVersion = lwmCatalogVersion - 1; catalogVersion >= earliestCatalogVersion; --catalogVersion) {
            for (CatalogTableDescriptor table : catalogService.tables(catalogVersion)) {
                if (!tableIds.add(table.id())) continue;
                res.add(new DroppedTableInfo(table.id(), catalogVersion + 1));
            }
        }
        return res;
    }

    public static boolean isDirectFlowApplicableTx(@Nullable InternalTransaction tx) {
        return tx == null || tx.implicit() && tx.isReadOnly();
    }
}

