/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.queue;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.compute.ComputeException;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.queue.ComputeThreadPoolExecutor;
import org.apache.ignite.internal.compute.queue.QueueEntry;
import org.apache.ignite.internal.compute.queue.QueueExecution;
import org.apache.ignite.internal.compute.queue.QueueOverflowException;
import org.apache.ignite.internal.compute.state.ComputeStateMachine;
import org.apache.ignite.internal.compute.state.IllegalJobStatusTransition;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

class QueueExecutionImpl<R>
implements QueueExecution<R> {
    private static final IgniteLogger LOG = Loggers.forClass(QueueExecutionImpl.class);
    private final UUID jobId;
    private final Callable<CompletableFuture<R>> job;
    private final ComputeThreadPoolExecutor executor;
    private final ComputeStateMachine stateMachine;
    private final CompletableFuture<R> result = new CompletableFuture();
    private final Lock executionLock = new ReentrantLock();
    @Nullable
    private volatile QueueEntry<R> queueEntry;
    private volatile int priority;
    private final AtomicInteger retries = new AtomicInteger();

    QueueExecutionImpl(UUID jobId, Callable<CompletableFuture<R>> job, int priority, ComputeThreadPoolExecutor executor, ComputeStateMachine stateMachine) {
        this.jobId = jobId;
        this.job = job;
        this.priority = priority;
        this.executor = executor;
        this.stateMachine = stateMachine;
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.result;
    }

    @Override
    @Nullable
    public JobState state() {
        return this.stateMachine.currentState(this.jobId);
    }

    @Override
    public boolean cancel() {
        try {
            this.stateMachine.cancelingJob(this.jobId);
            QueueEntry<R> queueEntry = this.queueEntry;
            if (queueEntry != null) {
                this.cancel(queueEntry);
                return true;
            }
        }
        catch (IllegalJobStatusTransition e) {
            LOG.info("Cannot cancel the job", (Throwable)((Object)e));
        }
        return false;
    }

    private void cancel(QueueEntry<R> queueEntry) {
        this.executionLock.lock();
        try {
            if (this.executor.remove(queueEntry)) {
                this.result.cancel(true);
            } else {
                queueEntry.interrupt();
            }
        }
        finally {
            this.executionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changePriority(int newPriority) {
        if (newPriority == this.priority) {
            return false;
        }
        this.executionLock.lock();
        try {
            QueueEntry<R> queueEntry = this.queueEntry;
            if (queueEntry != null && this.executor.removeFromQueue(queueEntry)) {
                this.priority = newPriority;
                this.queueEntry = null;
                this.run();
                boolean bl = true;
                return bl;
            }
            LOG.info("Cannot change job priority, job already processing. [job id = {}]", new Object[]{this.jobId});
        }
        finally {
            this.executionLock.unlock();
        }
        return false;
    }

    void run(int numRetries) {
        this.retries.set(numRetries);
        this.run();
    }

    private void run() {
        QueueEntry queueEntry = new QueueEntry(() -> {
            this.stateMachine.executeJob(this.jobId);
            return this.job.call();
        }, this.priority);
        this.queueEntry = queueEntry;
        this.executionLock.lock();
        try {
            this.executor.execute(queueEntry);
        }
        catch (QueueOverflowException e) {
            this.result.completeExceptionally((Throwable)new ComputeException(ErrorGroups.Compute.QUEUE_OVERFLOW_ERR, (Throwable)e));
            return;
        }
        finally {
            this.executionLock.unlock();
        }
        queueEntry.toFuture().whenComplete((r, throwable) -> {
            if (throwable != null) {
                if (this.retries.decrementAndGet() >= 0) {
                    this.stateMachine.queueJob(this.jobId);
                    this.run();
                } else {
                    try {
                        if (queueEntry.isInterrupted()) {
                            this.stateMachine.cancelJob(this.jobId);
                        } else {
                            this.stateMachine.failJob(this.jobId);
                        }
                    }
                    catch (IllegalJobStatusTransition err) {
                        throwable.addSuppressed((Throwable)((Object)err));
                        this.result.completeExceptionally((Throwable)throwable);
                    }
                    this.result.completeExceptionally((Throwable)throwable);
                }
            } else if (queueEntry.isInterrupted()) {
                this.stateMachine.cancelJob(this.jobId);
                this.result.completeExceptionally(new CancellationException());
            } else {
                this.stateMachine.completeJob(this.jobId);
                this.result.complete(r);
            }
        });
    }
}

