/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.metadata;

import io.scalecube.cluster.Member;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.StringJoiner;

final class GetMetadataResponse
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Member member;
    private ByteBuffer metadata;

    public GetMetadataResponse() {
    }

    GetMetadataResponse(Member member, ByteBuffer metadata) {
        this.member = member;
        this.metadata = metadata;
    }

    Member getMember() {
        return this.member;
    }

    ByteBuffer getMetadata() {
        return this.metadata;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.member);
        byte[] metadataBytes = this.metadata.array();
        out.writeInt(metadataBytes.length);
        out.write(metadataBytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.member = (Member)in.readObject();
        int metadataSize = in.readInt();
        byte[] metadataBytes = new byte[metadataSize];
        in.readFully(metadataBytes);
        this.metadata = ByteBuffer.wrap(metadataBytes);
    }

    public String toString() {
        return new StringJoiner(", ", GetMetadataResponse.class.getSimpleName() + "[", "]").add("member=" + this.member).add("metadata(b=" + this.metadata.remaining() + ")").toString();
    }
}

