/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.table.Table;

public class ClientTablesGetRequest {
    public static CompletableFuture<ResponseWriter> process(IgniteTables igniteTables) {
        return igniteTables.tablesAsync().thenApply(tables -> out -> {
            out.packInt(tables.size());
            for (Table table : tables) {
                TableViewInternal tableImpl = (TableViewInternal)table;
                out.packInt(tableImpl.tableId());
                out.packString(ClientTablesGetRequest.quoteTableNameIfNotAllUpper(table.qualifiedName().objectName()));
            }
        });
    }

    private static String quoteTableNameIfNotAllUpper(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isDigit(ch) || ch == '_' || Character.isUpperCase(ch)) continue;
            return IgniteNameUtils.quoteIfNeeded(name);
        }
        return name;
    }
}

