/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.freelist;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.Storable;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.jetbrains.annotations.Nullable;

public class IndexColumns
implements Storable {
    public static final byte DATA_TYPE = 1;
    public static final int SIZE_OFFSET = 1;
    public static final int VALUE_OFFSET = 5;
    private final int partitionId;
    private long link = 0L;
    @Nullable
    private final ByteBuffer valueBuffer;

    public IndexColumns(int partitionId, @Nullable ByteBuffer valueBuffer) {
        this.partitionId = partitionId;
        this.valueBuffer = valueBuffer;
    }

    public IndexColumns(int partitionId, long link, @Nullable ByteBuffer valueBuffer) {
        this.partitionId = partitionId;
        this.link = link;
        this.valueBuffer = valueBuffer;
    }

    public int valueSize() {
        assert (this.valueBuffer != null);
        return this.valueBuffer.limit();
    }

    public ByteBuffer valueBuffer() {
        return this.valueBuffer;
    }

    @Override
    public void link(long link) {
        this.link = link;
    }

    @Override
    public long link() {
        return this.link;
    }

    @Override
    public int partition() {
        return this.partitionId;
    }

    @Override
    public int size() throws IgniteInternalCheckedException {
        return 5 + this.valueSize();
    }

    @Override
    public int headerSize() {
        return 6;
    }

    @Override
    public void writeRowData(long pageAddr, int dataOff, int payloadSize, boolean newRow) {
        PageUtils.putShort(pageAddr, dataOff, (short)payloadSize);
        PageUtils.putByte(pageAddr, (dataOff += 2) + 0, (byte)1);
        PageUtils.putInt(pageAddr, dataOff + 1, this.valueSize());
        PageUtils.putByteBuffer(pageAddr, dataOff + 5, this.valueBuffer());
    }

    @Override
    public void writeFragmentData(ByteBuffer pageBuf, int rowOff, int payloadSize) {
        if (rowOff == 0) {
            assert (this.headerSize() <= payloadSize);
            pageBuf.put((byte)1);
            pageBuf.putInt(this.valueSize());
            Storable.putValueBufferIntoPage(pageBuf, this.valueBuffer, 0, payloadSize - 5);
        } else {
            assert (rowOff >= this.headerSize());
            Storable.putValueBufferIntoPage(pageBuf, this.valueBuffer, rowOff - 5, payloadSize);
        }
    }
}

