/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class LongJVMPauseDetector {
    public static final int DEFAULT_JVM_PAUSE_DETECTOR_THRESHOLD = 500;
    public static final int DFLT_JVM_PAUSE_DETECTOR_PRECISION = 50;
    public static final int DFLT_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT = 20;
    private static final int PRECISION = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_PRECISION", 50);
    private static final int THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD", 500);
    private static final int EVT_CNT = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT", 20);
    private static final boolean DISABLED = IgniteSystemProperties.getBoolean("IGNITE_JVM_PAUSE_DETECTOR_DISABLED");
    private final IgniteLogger log;
    private final AtomicReference<Thread> workerRef = new AtomicReference();
    private long longPausesCnt;
    private long longPausesTotalDuration;
    private long lastWakeUpTime;
    @GridToStringInclude
    private final long[] longPausesTimestamps = new long[EVT_CNT];
    @GridToStringInclude
    private final long[] longPausesDurations = new long[EVT_CNT];

    public LongJVMPauseDetector(IgniteLogger log) {
        this.log = log;
    }

    public void start() {
        if (DISABLED) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("JVM Pause Detector is disabled.");
            }
            return;
        }
        Thread worker = new Thread("jvm-pause-detector-worker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LongJVMPauseDetector longJVMPauseDetector = LongJVMPauseDetector.this;
                synchronized (longJVMPauseDetector) {
                    LongJVMPauseDetector.this.lastWakeUpTime = System.currentTimeMillis();
                }
                if (LongJVMPauseDetector.this.log.isDebugEnabled()) {
                    LongJVMPauseDetector.this.log.debug(this.getName() + " has been started.");
                }
                while (true) {
                    try {
                        LongJVMPauseDetector longJVMPauseDetector2;
                        Thread.sleep(PRECISION);
                        long now = System.currentTimeMillis();
                        long pause = now - (long)PRECISION - LongJVMPauseDetector.this.lastWakeUpTime;
                        if (pause >= (long)THRESHOLD) {
                            LongJVMPauseDetector.this.log.warning("Possible too long JVM pause: " + pause + " milliseconds.");
                            longJVMPauseDetector2 = LongJVMPauseDetector.this;
                            synchronized (longJVMPauseDetector2) {
                                int next = (int)(LongJVMPauseDetector.this.longPausesCnt % (long)EVT_CNT);
                                LongJVMPauseDetector.this.longPausesCnt++;
                                LongJVMPauseDetector.this.longPausesTotalDuration = LongJVMPauseDetector.this.longPausesTotalDuration + pause;
                                ((LongJVMPauseDetector)LongJVMPauseDetector.this).longPausesTimestamps[next] = now;
                                ((LongJVMPauseDetector)LongJVMPauseDetector.this).longPausesDurations[next] = pause;
                                LongJVMPauseDetector.this.lastWakeUpTime = now;
                                continue;
                            }
                        }
                        longJVMPauseDetector2 = LongJVMPauseDetector.this;
                        synchronized (longJVMPauseDetector2) {
                            LongJVMPauseDetector.this.lastWakeUpTime = now;
                        }
                    }
                    catch (InterruptedException e) {
                        if (LongJVMPauseDetector.this.workerRef.compareAndSet(this, null)) {
                            LongJVMPauseDetector.this.log.error(this.getName() + " has been interrupted.", e);
                        } else if (LongJVMPauseDetector.this.log.isDebugEnabled()) {
                            LongJVMPauseDetector.this.log.debug(this.getName() + " has been stopped.");
                        }
                        return;
                    }
                }
            }
        };
        if (!this.workerRef.compareAndSet(null, worker)) {
            this.log.warning(LongJVMPauseDetector.class.getSimpleName() + " already started!");
            return;
        }
        worker.setDaemon(true);
        worker.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug("LongJVMPauseDetector was successfully started");
        }
    }

    public void stop() {
        Thread worker = this.workerRef.getAndSet(null);
        if (worker != null && worker.isAlive() && !worker.isInterrupted()) {
            worker.interrupt();
        }
    }

    public static boolean enabled() {
        return !DISABLED;
    }

    synchronized long longPausesCount() {
        return this.longPausesCnt;
    }

    synchronized long longPausesTotalDuration() {
        return this.longPausesTotalDuration;
    }

    public synchronized long getLastWakeUpTime() {
        return this.lastWakeUpTime;
    }

    synchronized Map<Long, Long> longPauseEvents() {
        TreeMap<Long, Long> evts = new TreeMap<Long, Long>();
        for (int i = 0; i < this.longPausesTimestamps.length && this.longPausesTimestamps[i] != 0L; ++i) {
            evts.put(this.longPausesTimestamps[i], this.longPausesDurations[i]);
        }
        return evts;
    }

    @Nullable
    public synchronized IgniteBiTuple<Long, Long> getLastLongPause() {
        int lastPauseIdx = (int)(((long)EVT_CNT + this.longPausesCnt - 1L) % (long)EVT_CNT);
        if (this.longPausesTimestamps[lastPauseIdx] == 0L) {
            return null;
        }
        return new IgniteBiTuple<Long, Long>(this.longPausesTimestamps[lastPauseIdx], this.longPausesDurations[lastPauseIdx]);
    }

    public String toString() {
        return S.toString(LongJVMPauseDetector.class, this);
    }
}

